/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null));
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, false, string);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, string2, true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2, boolean bl2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ContentInfo contentInfo;
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        AlgorithmIdentifier algorithmIdentifier;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        this._digests.clear();
        for (Object object2 : this._signers) {
            try {
                algorithmIdentifier = this.makeAlgId(((SignerInformation)object2).getDigestAlgOID(), ((SignerInformation)object2).getDigestAlgParams());
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
            aSN1EncodableVector2.add((DEREncodable)((SignerInformation)object2).toSignerInfo());
        }
        for (Object object2 : this.signerInfs) {
            try {
                algorithmIdentifier = this.makeAlgId(((SignerInf)object2).getDigestAlgOID(), ((SignerInf)object2).getDigestAlgParams());
                aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
                aSN1EncodableVector2.add((DEREncodable)((SignerInf)object2).toSignerInfo(dERObjectIdentifier, cMSProcessable, string2, bl2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        object2 = null;
        if (this._certs.size() != 0) {
            object2 = CMSUtils.createBerSetFromList(this._certs);
        }
        algorithmIdentifier = null;
        if (this._crls.size() != 0) {
            algorithmIdentifier = CMSUtils.createBerSetFromList(this._crls);
        }
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                cMSProcessable.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("encapsulation error.", iOException);
            }
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
            contentInfo = new ContentInfo(dERObjectIdentifier, (DEREncodable)bERConstructedOctetString);
        } else {
            contentInfo = new ContentInfo(dERObjectIdentifier, null);
        }
        byteArrayOutputStream = new SignedData((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), contentInfo, (ASN1Set)object2, (ASN1Set)algorithmIdentifier, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector2));
        bERConstructedOctetString = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)byteArrayOutputStream);
        return new CMSSignedData(cMSProcessable, (ContentInfo)bERConstructedOctetString);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    private class SignerInf {
        PrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.digestOID = string;
            this.encOID = string2;
        }

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, String string, boolean bl) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            DEROutputStream dEROutputStream;
            AttributeTable attributeTable;
            Map map;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            String string2 = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String string3 = string2 + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string3, string);
            MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string2, string);
            byte[] byArray = null;
            if (cMSProcessable != null) {
                cMSProcessable.write(new DigOutputStream(messageDigest));
                byArray = messageDigest.digest();
                CMSSignedDataGenerator.this._digests.put(this.digestOID, byArray.clone());
            }
            if (bl) {
                map = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                attributeTable = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(map)) : null;
            } else {
                attributeTable = this.baseSignedTable;
            }
            map = CMSSignedDataGenerator.this.getAttributeSet(attributeTable);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (map != null) {
                dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
                dEROutputStream.writeObject((Object)map);
            } else {
                cMSProcessable.write(byteArrayOutputStream);
            }
            signature.initSign(this.key);
            signature.update(byteArrayOutputStream.toByteArray());
            dEROutputStream = new DEROctetString(signature.sign());
            Map map2 = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
            map2.put("encryptedDigest", dEROutputStream.getOctets().clone());
            AttributeTable attributeTable2 = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(map2)) : null;
            ASN1Set aSN1Set = CMSSignedDataGenerator.this.getAttributeSet(attributeTable2);
            X509Certificate x509Certificate = this.getCertificate();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), algorithmIdentifier, (ASN1Set)map, algorithmIdentifier2, (ASN1OctetString)dEROutputStream, aSN1Set);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature signature) {
            this.sig = signature;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }

        @Override
        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

