/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.common.taglib;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import jp.nyx.NyxException;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.User;
import jp.nyx.common.rpc.client.NyxXmlClient;
import jp.nyx.common.util.WebUtility;

public abstract class NTag
extends TagSupport {
    protected final WebUtility webUtil = new WebUtility();
    protected final NyxXmlClient client = new NyxXmlClient();
    protected boolean enableTitle = true;
    private static Map<String, Setting> NYX_SETTING = null;
    private JspWriter out = null;
    private String userId = null;
    private boolean admin = false;
    private String id = null;
    private String clazz = null;
    private String style = "";
    private String title = null;
    private int width = -1;
    private int height = -1;

    protected Map<String, Setting> loadNyx() throws JspException {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String header = req.getHeader("NyxAuthGate");
        if (this.webUtil.textUtil.isEmpty(header)) {
            Map nyx = (Map)req.getAttribute("nyxSetting");
            if (nyx != null) {
                return nyx;
            }
            header = "";
        }
        return (Map)this.client.xmlrpc(req, header, "NyxSetting.getNyx", new Object[0]);
    }

    protected User loadUser(String user_id) throws JspException {
        String selfId;
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String header = req.getHeader("NyxAuthGate");
        if (this.webUtil.textUtil.isEmpty(header)) {
            header = "";
        }
        if (this.webUtil.textUtil.isEmpty(selfId = this.getUserId())) {
            User ret = new User();
            ret.setUserId(user_id);
            ret.setUserName(user_id);
            return ret;
        }
        return (User)this.client.xmlrpc(req, header, "Sso.getUser", new Object[]{selfId, user_id});
    }

    public int doStartTag() throws JspException {
        try {
            this.userId = this.webUtil.parseRequestUser((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        return 2;
    }

    protected String createBaseAttribute() {
        StringBuilder sb = new StringBuilder();
        if (!this.webUtil.textUtil.isEmpty(this.id)) {
            sb.append(" id=\"");
            sb.append(this.quate(this.id));
            sb.append("\"");
        }
        if (!this.webUtil.textUtil.isEmpty(this.clazz)) {
            sb.append(" class=\"");
            sb.append(this.quate(this.clazz));
            sb.append("\"");
        }
        StringBuilder styleSb = new StringBuilder();
        if (this.width >= 0) {
            styleSb.append("width:");
            styleSb.append(this.width);
            styleSb.append("px;");
        }
        if (this.height >= 0) {
            styleSb.append("height:");
            styleSb.append(this.height);
            styleSb.append("px;");
        }
        if (!this.webUtil.textUtil.isEmpty(this.style) || styleSb.length() > 0) {
            sb.append(" style=\"");
            sb.append(this.quate(this.style));
            sb.append((CharSequence)styleSb);
            sb.append("\"");
        }
        if (!this.webUtil.textUtil.isEmpty(this.title) && this.enableTitle) {
            sb.append(" title=\"");
            sb.append(this.quate(this.title));
            sb.append("\"");
        }
        return sb.toString();
    }

    protected String quate(String attributeValue) {
        if (this.webUtil.textUtil.isEmpty(attributeValue)) {
            return "";
        }
        return attributeValue.replaceAll("\"", "\\\"");
    }

    protected boolean isAdmin() {
        return this.admin;
    }

    protected String getUserId() {
        return this.userId;
    }

    protected Setting getSetting(String name) {
        try {
            if (NYX_SETTING == null) {
                NYX_SETTING = this.loadNyx();
            }
            return NYX_SETTING.get(name);
        }
        catch (JspException e) {
            e.printStackTrace();
            return new Setting();
        }
    }

    protected void out(String string) throws JspException {
        try {
            if (this.out == null) {
                this.out = this.pageContext.getOut();
            }
            this.out.print(string);
        }
        catch (IOException e) {
            if (NyxException.logger.isWarnEnabled()) {
                NyxException.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            JspException je = new JspException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
    }

    protected NTag findTag(Class type, String tagName) throws JspException {
        return this.findTag(type, tagName, true);
    }

    protected NTag findTag(Class type, String tagName, boolean notfoundThrow) throws JspException {
        Tag html = TagSupport.findAncestorWithClass((Tag)this, (Class)type);
        if (html == null && notfoundThrow) {
            throw new JspException("Not Found Nyx " + tagName + " tag.");
        }
        return (NTag)html;
    }

    protected abstract String getInitJs();

    public void reset() {
        this.clazz = null;
        this.width = -1;
        this.height = -1;
        this.id = null;
        this.style = null;
        this.title = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

