/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.pkg.sso.db.SsoContextDao;
import jp.nyx.pkg.sso.db.SsoSiteDao;
import jp.nyx.pkg.sso.db.SsoUserDao;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoAuthDao
extends BaseDao {
    private SsoUserDao ssoUserDao;
    private SsoContextDao ssoContextDao;
    private SsoSiteDao ssoSiteDao;
    private ParameterizedRowMapper<Auth> authMapper;
    private NyxManager nyxManager;

    protected SsoAuthDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate, SsoUserDao ssoUserDao, SsoContextDao ssoContextDao, SsoSiteDao ssoSiteDao) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.ssoUserDao = ssoUserDao;
        this.ssoContextDao = ssoContextDao;
        this.ssoSiteDao = ssoSiteDao;
        this.authMapper = new DefaultParameterizedRowMapper<Auth>(){

            public Auth mapRow(ResultSet rs, int rowNum) throws SQLException {
                Auth ret = new Auth();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setAuthId(rs.getInt("auth_id"));
                ret.setAuthName(rs.getString("auth_name"));
                ret.setTriggerSiteIdInt(rs.getInt("trigger_site_id"));
                ret.setAuthType(rs.getString("auth_type"));
                ret.setAuthUse(rs.getString("auth_use"));
                ret.setValidSiteIdInt(rs.getInt("valid_site_id"));
                ret.setFailerSiteIdInt(rs.getInt("failer_site_id"));
                return ret;
            }
        };
    }

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    public Auth loadAuth(int authId) {
        List ext = this.simpleTemplate.query("select * from m_auth_ext where auth_id=?", this.extMapper, new Object[]{authId});
        Auth ret = (Auth)this.simpleTemplate.queryForObject("select * from m_auth where auth_id=?", this.authMapper, new Object[]{authId});
        Map map = ret.getExt();
        for (Ext ex : ext) {
            map.put(ex.getFieldName(), ex);
        }
        List userIds = this.loadString("user_id", "m_auth_user", "auth_id", authId);
        Set user = ret.getUser();
        for (String i : userIds) {
            user.add(this.ssoUserDao.loadUser(i));
        }
        List contextCodes = this.loadInt("context_code", "m_auth_context", "auth_id", authId);
        Set context = ret.getContext();
        for (Integer i : contextCodes) {
            context.add(this.ssoContextDao.loadContext(i));
        }
        List appIds = this.loadInt("app_site_id", "m_auth_app", "auth_id", authId);
        Set appSite = ret.getAppSiteId();
        for (Integer i : appIds) {
            appSite.add(this.ssoSiteDao.loadSite(i));
        }
        return ret;
    }

    public List<Auth> loadAuth(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadInt("auth_id", "m_auth", conditions, offset, limit, "auth_name");
        if (ids.size() <= 0) {
            return new ArrayList<Auth>();
        }
        ArrayList<Auth> ret = new ArrayList<Auth>();
        for (Integer i : ids) {
            ret.add(this.loadAuth(i));
        }
        return ret;
    }

    public void saveAuth(Auth auth) throws SQLException {
        int r = this.namedTemplate.update("update m_auth set auth_name=:authName " + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ",trigger_site_id=:triggerSiteIdInt ") + ",auth_type=:authType " + ",auth_use=:authUse " + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ",valid_site_id=:validSiteIdInt ") + txtUtil.getEmpty((Object)auth.getFailerSiteIdInt(), ",failer_site_id=:failerSiteIdInt ") + "where auth_id=:authId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)auth));
        if (r > 0) {
            this.saveExt("m_auth_ext", "auth_id", auth.getAuthId(), auth.getExt());
            this.saveRef("m_auth_app", "app_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getAppSiteId());
            this.saveRef("m_auth_user", "user_id", "userId", "auth_id", auth.getAuthId(), auth.getUser());
            this.saveRef("m_auth_context", "context_code", "contextCode", "auth_id", auth.getAuthId(), auth.getContext());
            this.saveSsoDefault("m_auth", "auth_id", auth.getAuthId(), (DefaultModel)auth);
            return;
        }
        int seq = this.nextSequence("m_auth_auth_id_seq");
        auth.setAuthId(seq);
        this.namedTemplate.update("insert into m_auth(auth_id, auth_name" + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ", trigger_site_id") + ", auth_type, auth_use" + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ", valid_site_id") + txtUtil.getEmpty((Object)auth.getFailerSiteIdInt(), ", failer_site_id") + ") values(:authId, :authName" + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ", :triggerSiteIdInt") + ", :authType, :authUse" + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ", :validSiteIdInt") + txtUtil.getEmpty((Object)auth.getFailerSiteIdInt(), ", :failerSiteIdInt") + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)auth));
        this.saveExt("m_auth_ext", "auth_id", auth.getAuthId(), auth.getExt());
        this.saveRef("m_auth_app", "app_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getAppSiteId());
        this.saveRef("m_auth_user", "user_id", "userId", "auth_id", auth.getAuthId(), auth.getUser());
        this.saveRef("m_auth_context", "context_code", "contextCode", "auth_id", auth.getAuthId(), auth.getContext());
        this.saveSsoDefault("m_auth", "auth_id", auth.getAuthId(), (DefaultModel)auth);
    }

    public void deleteAuth(int auth_id) {
        this.simpleTemplate.update("delete from m_auth_ext where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_app where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_context where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_user where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth where auth_id=?", new Object[]{auth_id});
    }
}

