/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.pkg.sso.db.model.Log;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoLogDao
extends BaseDao {
    private ParameterizedRowMapper<Log> logMapper;
    private NyxManager nyxManager;

    protected SsoLogDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.logMapper = new DefaultParameterizedRowMapper<Log>(){

            public Log mapRow(ResultSet rs, int rowNum) throws SQLException {
                Log ret = new Log();
                ret.setSeq(rs.getInt("seq"));
                ret.setLogDate(rs.getTimestamp("log_date"));
                ret.setLogLevel(rs.getString("log_level"));
                ret.setAct(rs.getString("act"));
                ret.setActMs(rs.getInt("act_ms"));
                ret.setAuthType(rs.getString("auth_type"));
                ret.setAuthUse(rs.getString("auth_use"));
                ret.setAuthUserId(rs.getString("auth_user_id"));
                ret.setClientIp(rs.getString("client_ip"));
                ret.setTriggerMethod(rs.getString("trigger_method"));
                ret.setTriggerUrl(rs.getString("trigger_url"));
                ret.setValidUrl(rs.getString("valid_url"));
                ret.setCause(rs.getString("cause"));
                ret.setSession(rs.getString("session"));
                return ret;
            }
        };
    }

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    public List<Log> loadLog(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadInt("seq", "t_log", conditions, offset, limit, "log_date desc");
        if (ids.size() <= 0) {
            return new ArrayList<Log>();
        }
        ArrayList<Log> ret = new ArrayList<Log>();
        for (Integer i : ids) {
            ret.add(this.loadLog(i));
        }
        return ret;
    }

    public Log loadLog(int seq) {
        Log ret = (Log)this.simpleTemplate.queryForObject("select * from t_log where seq=?", this.logMapper, new Object[]{seq});
        return ret;
    }

    public List<Map<String, Object>> loadLogGroup(String coloum, String cntName, String order, int offset, int limit, ConditionList conditions) throws SQLException {
        ArrayList<Integer> cond = new ArrayList<Integer>();
        String where = BaseDao.genWhereString((ConditionList)conditions, cond);
        if (this.nyxManager.isPostgreSQL()) {
            cond.add(offset);
            cond.add(limit);
            return this.simpleTemplate.queryForList("select " + coloum + " as col, count(*) as " + cntName + " from t_log" + where + " group by " + coloum + " order by " + order + " offset ? limit ?", cond.toArray());
        }
        return this.simpleTemplate.queryForList("select " + coloum + " as col, count(*) as " + cntName + " from t_log" + where + " group by " + coloum + " order by " + order, cond.toArray());
    }

    public void saveLog(Log log) throws SQLException {
        int seq = this.nextSequence("t_log_seq");
        log.setSeq(seq);
        this.namedTemplate.update("insert into t_log(log_date, log_level, act, act_ms, auth_type, auth_use, auth_user_id, client_ip, trigger_method, trigger_url, valid_url, cause, session) values(:logDate, :logLevel, :act, :actMs, :authType, :authUse, :authUserId, :clientIp, :triggerMethod, :triggerUrl, :validUrl, :cause, :session)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)log));
    }

    public void deleteLog(int seq) {
        this.simpleTemplate.update("delete from t_log where seq=?", new Object[]{seq});
    }

    public void deleteLog(ConditionList conditions) {
        ArrayList cond = new ArrayList();
        String where = BaseDao.genWhereString((ConditionList)conditions, cond);
        this.simpleTemplate.update("delete from t_log" + where, cond.toArray());
    }
}

