/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Site;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoSiteDao
extends BaseDao {
    private ParameterizedRowMapper<Site> siteMapper;
    private NyxManager nyxManager;

    protected SsoSiteDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.siteMapper = new DefaultParameterizedRowMapper<Site>(){

            public Site mapRow(ResultSet rs, int rowNum) throws SQLException {
                Site ret = new Site();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setSiteId(rs.getInt("site_id"));
                ret.setSiteName(rs.getString("site_name"));
                ret.setSiteType(rs.getString("site_type"));
                ret.setSiteProtocol(rs.getString("site_protocol"));
                ret.setSiteHost(rs.getString("site_host"));
                ret.setSitePort(rs.getInt("site_port"));
                ret.setSitePath(rs.getString("site_path"));
                return ret;
            }
        };
    }

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    public Site loadSite(int siteId) {
        Site ret = (Site)this.simpleTemplate.queryForObject("select * from m_site where site_id=?", this.siteMapper, new Object[]{siteId});
        return ret;
    }

    public List<Site> loadSite(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadInt("site_id", "m_site", conditions, offset, limit, "site_name");
        if (ids.size() <= 0) {
            return new ArrayList<Site>();
        }
        ArrayList<Site> ret = new ArrayList<Site>();
        for (Integer i : ids) {
            ret.add(this.loadSite(i));
        }
        return ret;
    }

    public void saveSite(Site site) throws SQLException {
        int r = this.namedTemplate.update("update m_site set site_name=:siteName ,site_type=:siteType ,site_protocol=:siteProtocol ,site_host=:siteHost ,site_port=:sitePort ,site_path=:sitePath where site_id=:siteId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)site));
        if (r > 0) {
            this.saveSsoDefault("m_site", "site_id", site.getSiteId(), (DefaultModel)site);
            return;
        }
        int seq = this.nextSequence("m_site_site_id_seq");
        site.setSiteId(seq);
        this.namedTemplate.update("insert into m_site(site_id, site_name, site_type, site_protocol, site_host, site_port, site_path) values(:siteId, :siteName, :siteType, :siteProtocol, :siteHost, :sitePort, :sitePath)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)site));
        this.saveSsoDefault("m_site", "site_id", site.getSiteId(), (DefaultModel)site);
    }

    public void deleteSite(int site_id) {
        this.simpleTemplate.update("delete from m_portal_menu_user where site_id=?", new Object[]{site_id});
        this.simpleTemplate.update("delete from m_site where site_id=?", new Object[]{site_id});
    }
}

