/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.Site;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class SiteController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        ssoManager.init((ApplicationContext)super.getWebApplicationContext());
        String site_name_search = request.getParameter("site_name_search");
        String site_type_search = request.getParameter("site_type_search");
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        if (!this.webUtil.textUtil.isEmpty(site_name_search)) {
            cond.add((Object)new Condition("site_name", (Object)("%" + site_name_search + "%"), "like"));
        }
        if (this.webUtil.textUtil.isEmpty(site_type_search)) {
            site_type_search = "trigger";
        }
        if (!"all".equals(site_type_search)) {
            cond.add((Object)new Condition("site_type", (Object)site_type_search, "="));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_site", cond));
        List<Site> sites = ssoManager.loadSite(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("sites", sites);
        if ("add".equals(request.getParameter("mode"))) {
            Site site = new Site();
            mv.getModel().put("site", site);
        } else if ("adddo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Site site = new Site();
                site.setRegistUid(this.getRemoteUser(mv));
                site.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(site, request, status)) {
                    return mv;
                }
                ssoManager.saveSite(site);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(request.getParameter("mode"))) {
            Site site = ssoManager.loadSite(this.webUtil.numUtil.parseInt(request.getParameter("site_id")));
            mv.getModel().put("site", site);
        } else if ("editdo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Site site = ssoManager.loadSite(this.webUtil.numUtil.parseInt(request.getParameter("site_id")));
                if (!this.save(site, request, status)) {
                    return mv;
                }
                site.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveSite(site);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deleteSite(this.webUtil.numUtil.parseInt(request.getParameter("site_id")));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(Site site, HttpServletRequest request, Map<String, String> status) throws NoSuchAlgorithmException, MessagingException, IOException {
        Calendar cal;
        String site_name = request.getParameter("site_name");
        if (this.webUtil.textUtil.isEmpty(site_name)) {
            status.put("status", "Failed");
            status.put("message", "\u30b5\u30a4\u30c8\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        site.setSiteName(site_name);
        site.setSiteType(request.getParameter("site_type"));
        site.setSiteProtocol(request.getParameter("site_protocol"));
        site.setSiteHost(request.getParameter("site_host"));
        site.setSitePort(this.webUtil.numUtil.parseInt(request.getParameter("site_port"), -1));
        site.setSitePath(request.getParameter("site_path"));
        if (this.webUtil.textUtil.isEmpty(site.getSiteProtocol())) {
            site.setSiteProtocol("http");
        }
        if (this.webUtil.textUtil.isEmpty(site.getSiteHost())) {
            site.setSiteHost("localhost");
        }
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                site.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            site.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                site.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            site.setVerifyEnddate(null);
        }
        site.setEnable("true".equals(request.getParameter("enable")));
        return true;
    }
}

