/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.SQLException;
import java.util.Map;
import java.util.ResourceBundle;
import jp.nyx.common.db.NyxDao;
import jp.nyx.common.db.Setting;
import jp.nyx.common.util.WebUtility;

public class NyxManager {
    private NyxDao dao;
    private Map<String, Setting> nyx;
    public final WebUtility webUtil = new WebUtility();

    public void setNyxDao(NyxDao dao) {
        this.dao = dao;
    }

    public void init() throws SQLException {
        if (this.dao.isInit()) {
            return;
        }
        ResourceBundle conf = ResourceBundle.getBundle("jp.nyx.common.db.nyx_sql");
        String[] sql = conf.getString("sql").split(";");
        for (int i = 0; i < sql.length; ++i) {
            if (sql[i] == null || sql[i].trim().length() <= 0) continue;
            this.dao.update(sql[i].replaceAll("<semicolon>", ";"));
        }
    }

    public Map<String, Setting> loadSetting() throws SQLException {
        if (this.nyx != null) {
            return this.nyx;
        }
        this.nyx = this.dao.loadSetting();
        return this.nyx;
    }

    public void saveSetting(Map<String, Setting> setting) {
        this.dao.saveSetting(setting);
    }

    public boolean isPostgreSQL() throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return "postgresql".equals(nyx.get("ca_jdbc_type").getValue());
    }

    public boolean isDerby() throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return !"postgresql".equals(nyx.get("ca_jdbc_type").getValue());
    }
}

