/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.sreg;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.sreg.SRegMessage;

public class SRegRequest
extends SRegMessage {
    private static Logger _log = Logger.getLogger((Class)SRegRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected SRegRequest() {
        if (DEBUG) {
            _log.debug((Object)"Created empty SReg request.");
        }
    }

    public static SRegRequest createFetchRequest() {
        return new SRegRequest();
    }

    protected SRegRequest(ParameterList params) {
        this._parameters = params;
    }

    public static SRegRequest createSRegRequest(ParameterList params) throws MessageException {
        SRegRequest req = new SRegRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a SReg request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created SReg request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String attr, boolean required) {
        Parameter newParam;
        String level = required ? "required" : "optional";
        Parameter levelParam = this._parameters.getParameter(level);
        if (levelParam == null) {
            newParam = new Parameter(level, this.multivalEncode(attr));
        } else {
            newParam = new Parameter(level, levelParam.getValue() + "," + this.multivalEncode(attr));
            this._parameters.removeParameters(level);
        }
        this._parameters.set(newParam);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to SReg request: " + attr + " required: " + required));
        }
    }

    public List getAttributes(boolean required) {
        ArrayList<String> attributes = new ArrayList<String>();
        String level = required ? "required" : "optional";
        Parameter param = this._parameters.getParameter(level);
        if (param != null) {
            String[] values = param.getValue().split(",");
            for (int i = 0; i < values.length; ++i) {
                String attr = this.multivalDecode(values[i]);
                attributes.add(attr);
            }
        }
        return attributes;
    }

    public List getAttributes() {
        List attributes = this.getAttributes(true);
        attributes.addAll(this.getAttributes(false));
        return attributes;
    }

    public void setPolicyUrl(String policyUrl) throws MessageException {
        try {
            new URL(policyUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid policy_url: " + policyUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting SReg request policy_url: " + policyUrl));
        }
        this._parameters.set(new Parameter("policy_url", policyUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("policy_url") ? this._parameters.getParameterValue("policy_url") : null;
    }

    public boolean isValid() {
        if (!this._parameters.hasParameter("required") && !this._parameters.hasParameter("optional")) {
            _log.warn((Object)"One of 'required' or 'optional' parameters must be present.");
            return false;
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("required") || paramName.equals("optional") || paramName.equals("policy_url")) continue;
            _log.warn((Object)("Invalid parameter name in SReg request: " + paramName));
        }
        return true;
    }
}

