/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.common.taglib.component;

import javax.servlet.jsp.JspException;
import jp.nyx.pkg.common.taglib.NComponentTag;
import jp.nyx.pkg.common.taglib.component.NFormTag;

public class NTextareaTag
extends NComponentTag {
    private int rows = 3;
    private int cols = 20;
    private boolean allowBlank = true;

    @Override
    public int doStartTag() throws JspException {
        if (!this.isSelfinit()) {
            this.findTag(NFormTag.class, "form");
        }
        super.doStartTag();
        this.out("<textarea" + this.createBaseAttribute());
        int size = this.getSize();
        int maxlength = this.getMaxlength();
        this.setSize(-1);
        this.setMaxlength(-1);
        if (this.getRows() > 0) {
            this.out(" rows=\"" + this.getRows() + "\"");
        }
        if (this.getCols() > 0) {
            this.out(" cols=\"" + this.getCols() + "\"");
        }
        this.out("\">");
        this.setSize(size);
        this.setMaxlength(maxlength);
        return 1;
    }

    @Override
    public int doEndTag() throws JspException {
        if (!this.isSelfinit()) {
            NFormTag html = (NFormTag)this.findTag(NFormTag.class, "form");
            html.addCompJs(this.getInitJs());
            this.out("</textarea>");
        } else {
            this.out("</textarea>");
            this.out("<script type=\"text/javascript\">\n");
            this.out(this.getInitJs());
            this.out("\n</script>");
        }
        this.reset();
        return 6;
    }

    @Override
    protected String getInitJs() {
        StringBuffer js = new StringBuffer();
        js.append("{var cmb = new Ext.form.TextArea({");
        js.append("allowBlank:");
        js.append(this.allowBlank);
        js.append(",applyTo:'");
        js.append(this.getId());
        js.append("',style:'display:inline;");
        js.append(this.getStyle());
        js.append("'});");
        if (!this.webUtil.textUtil.isEmpty(this.getOnclick())) {
            js.append("cmb.on('click', function(e){");
            js.append(this.getOnclick());
            js.append("});");
        }
        if (!this.webUtil.textUtil.isEmpty(this.getOnchange())) {
            js.append("cmb.on('change', function(e){");
            js.append(this.getOnchange());
            js.append("});");
        }
        js.append("};\n");
        return js.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.rows = 3;
        this.cols = 20;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public boolean isAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }
}

