/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.app.old;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import jp.nyx.common.util.CalendarUtility;
import jp.nyx.common.util.NumberUtility;
import jp.nyx.common.util.TextUtility;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import sun.misc.BASE64Decoder;

public abstract class SwitchContentsWeb
implements Serializable {
    public static final String CONF_NAME_BASE_URL = "BASE_URL";
    protected static final String CONF_NAME_SMTPSV_IP = "SMTPSV_IP";
    protected static final String CONF_NAME_SMTPSV_PORT = "SMTPSV_PORT";
    protected static final String CONF_NAME_PORTAL_URL = "PORTAL_URL";
    private static final String DB_PRODUCT_NAME_PGSQL = "PostgreSQL";
    private static final String DB_PRODUCT_NAME_MYSQL = "MySQL";
    private static final String DB_PRODUCT_NAME_DERBY = "Apache Derby";
    private static String uploadEncoding = "Windows-31J";
    public static final BASE64Decoder base64Decoder = new BASE64Decoder();
    public static final long DEFAULT_MAX_FILE_UPLOAD_SIZE = 512000L;
    private static final int CONNECTION_RETRY_COUNT = 5;
    private HashMap<Connection, ArrayList<PreparedStatement>> statementMap = new HashMap();
    private Context dsContext = null;
    private CalendarUtility calUtil = null;
    private NumberUtility numUtil = null;
    private TextUtility textUtil = null;

    public void init(ServletContext context) {
        try {
            String encoding = context.getInitParameter("UPLOAD_ENCODING");
            uploadEncoding = encoding != null ? encoding : uploadEncoding;
        }
        catch (Exception e) {
            context.log("web.xml loading failed.", (Throwable)e);
        }
        try {
            this.dsContext = new InitialContext();
        }
        catch (Exception e) {
            context.log("InitialContext failed", (Throwable)e);
        }
    }

    public static String getUploadEncoding() {
        return uploadEncoding;
    }

    protected Connection getConnection(DataSource ds) throws SQLException {
        Connection con = null;
        Throwable e = null;
        for (int i = 0; con == null && i < 5; ++i) {
            try {
                con = ds.getConnection();
                if (this.statementMap.containsKey(con)) continue;
                this.statementMap.put(con, new ArrayList());
                continue;
            }
            catch (Exception ex) {
                e = ex;
            }
        }
        if (e != null) {
            SQLException se = new SQLException(e.getMessage());
            se.initCause(e);
            throw se;
        }
        return con;
    }

    protected DataSource lookup(String dsName) throws NamingException {
        return (DataSource)this.dsContext.lookup(dsName);
    }

    protected DatabaseMetaData loadDbMeta(Connection con) throws SQLException {
        return con.getMetaData();
    }

    protected boolean isDbProductPgSQL(DatabaseMetaData dbMeta) throws SQLException {
        return DB_PRODUCT_NAME_PGSQL.equals(dbMeta.getDatabaseProductName());
    }

    protected boolean isDbProductMySQL(DatabaseMetaData dbMeta) throws SQLException {
        return DB_PRODUCT_NAME_MYSQL.equals(dbMeta.getDatabaseProductName());
    }

    protected boolean isDbProductDerby(DatabaseMetaData dbMeta) throws SQLException {
        return DB_PRODUCT_NAME_DERBY.equals(dbMeta.getDatabaseProductName());
    }

    public PreparedStatement createStatement(Connection con, String macroedSql) throws SQLException {
        PreparedStatement ret = con.prepareStatement(macroedSql);
        if (this.statementMap.containsKey(con)) {
            ArrayList<PreparedStatement> list = this.statementMap.get(con);
            list.add(ret);
        } else {
            ArrayList<PreparedStatement> list = new ArrayList<PreparedStatement>();
            list.add(ret);
            this.statementMap.put(con, list);
        }
        return ret;
    }

    public Statement createStatement(Connection con) throws SQLException {
        return con.createStatement();
    }

    public void commit(Connection con) throws SQLException {
        con.commit();
        if (this.statementMap.containsKey(con)) {
            ArrayList<PreparedStatement> list = this.statementMap.get(con);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement st = list.get(i);
                st.close();
            }
            this.statementMap.remove(con);
        }
        con.close();
    }

    public void rollback(Connection con) throws SQLException {
        try {
            con.rollback();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.statementMap.containsKey(con)) {
            ArrayList<PreparedStatement> list = this.statementMap.get(con);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement st = list.get(i);
                try {
                    st.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.statementMap.remove(con);
        }
        try {
            con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rollback() throws SQLException {
        for (Connection con : this.statementMap.keySet()) {
            ArrayList<PreparedStatement> list = this.statementMap.get(con);
            if (list == null) continue;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement st = list.get(i);
                try {
                    st.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                con.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        this.statementMap.clear();
    }

    public void closeStatement(PreparedStatement st) throws SQLException {
        try {
            Connection con = st.getConnection();
            ArrayList<PreparedStatement> list = this.statementMap.get(con);
            list.remove(st);
            st.close();
        }
        catch (Exception e) {
            st.close();
        }
    }

    public String loadUserName(String user_id, Connection con) throws SQLException {
        PreparedStatement st = this.createStatement(con, "select user_name from m_user where user_id=?");
        st.setString(1, user_id);
        ResultSet rs = st.executeQuery();
        if (!rs.next()) {
            this.closeStatement(st);
            return user_id;
        }
        String uname = rs.getString("user_name");
        this.closeStatement(st);
        return uname;
    }

    public String loadContextName(int context_code, Connection con) throws SQLException {
        PreparedStatement st = this.createStatement(con, "select context_name from m_context where context_code=?");
        st.setInt(1, context_code);
        ResultSet rs = st.executeQuery();
        if (!rs.next()) {
            this.closeStatement(st);
            return String.valueOf(context_code);
        }
        String context_name = rs.getString("context_name");
        this.closeStatement(st);
        return context_name;
    }

    public Map<String, String> loadPotalSetting(Connection con) throws SQLException {
        HashMap<String, String> conf = new HashMap<String, String>();
        PreparedStatement st = this.createStatement(con, "select * from m_portal_setting");
        ResultSet rs = st.executeQuery();
        TextUtility textUtil = this.getTextUtil();
        while (rs.next()) {
            String name = rs.getString("name");
            String value = rs.getString("value");
            if (textUtil.isEmpty(name)) continue;
            conf.put(name, value);
        }
        this.closeStatement(st);
        return conf;
    }

    protected void savePotalSetting(Connection con, Map<String, String> conf) throws SQLException {
        Iterator<String> keys = conf.keySet().iterator();
        PreparedStatement upSt = this.createStatement(con, "update m_portal_setting set value=? where name=?");
        PreparedStatement inSt = this.createStatement(con, "insert into m_portal_setting values(?, ?)");
        while (keys.hasNext()) {
            String k = keys.next();
            String v = conf.get(k);
            upSt.setString(1, v);
            upSt.setString(2, k);
            if (upSt.executeUpdate() > 0) continue;
            inSt.setString(1, k);
            inSt.setString(2, v);
            inSt.executeUpdate();
        }
        this.closeStatement(upSt);
        this.closeStatement(inSt);
    }

    public String getServerURL(HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        String schema = request.getScheme();
        int port = request.getServerPort();
        if ("http".equals(schema) && port == 80 || "https".equals(schema) && port == 443) {
            url.append(schema);
            url.append("://");
            url.append(request.getServerName());
        } else {
            url.append(schema);
            url.append("://");
            url.append(request.getServerName());
            url.append(":");
            url.append(port);
        }
        return url.toString();
    }

    public String getPotalURL(HttpServletRequest request) {
        return this.getServerURL(request) + "/portal/";
    }

    public CalendarUtility getCalUtil() {
        if (this.calUtil != null) {
            return this.calUtil;
        }
        this.calUtil = new CalendarUtility();
        return this.calUtil;
    }

    public NumberUtility getNumUtil() {
        if (this.numUtil != null) {
            return this.numUtil;
        }
        this.numUtil = new NumberUtility();
        return this.numUtil;
    }

    public TextUtility getTextUtil() {
        if (this.textUtil != null) {
            return this.textUtil;
        }
        this.textUtil = new TextUtility();
        return this.textUtil;
    }

    public static String loadRemoteUser(HttpServletRequest request) throws IOException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.contains("Basic ")) {
            return null;
        }
        String auth = authHeader.substring(authHeader.indexOf("Basic ") + "Basic ".length());
        auth = new String(base64Decoder.decodeBuffer(auth));
        return auth.substring(0, auth.indexOf(58));
    }

    public static Map<String, Object> uploadFile(ServletContext servlet, HttpServletRequest request) {
        return SwitchContentsWeb.uploadFile(servlet, request, 512000L);
    }

    public static Map<String, Object> uploadFile(ServletContext servlet, HttpServletRequest request, long maxUploadSize) {
        try {
            ServletRequestContext rcontext = new ServletRequestContext(request);
            if (!ServletFileUpload.isMultipartContent((RequestContext)rcontext)) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                Enumeration keys = request.getParameterNames();
                while (keys.hasMoreElements()) {
                    String k = (String)keys.nextElement();
                    String[] vs = request.getParameterValues(k);
                    if (vs != null) {
                        if (k.endsWith("[]") || k.endsWith("[]") && vs.length > 1) {
                            ret.put(k, vs);
                            continue;
                        }
                        ret.put(k, vs[0]);
                        continue;
                    }
                    ret.put(k, request.getParameter(k));
                }
                return ret;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(0x200000);
            String repositoryPath = servlet.getInitParameter("REPOSITORY_PATH");
            repositoryPath = repositoryPath == null ? "/WEB-INF/upfile" : repositoryPath;
            factory.setRepository(new File(servlet.getRealPath(repositoryPath)));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(maxUploadSize);
            upload.setHeaderEncoding(uploadEncoding);
            Iterator it = upload.parseRequest((RequestContext)rcontext).iterator();
            HashMap<String, Object> ret = new HashMap<String, Object>();
            while (it.hasNext()) {
                FileItem fi = (FileItem)it.next();
                if (!fi.isFormField()) {
                    ret.put(fi.getFieldName(), fi);
                    continue;
                }
                if (!fi.isFormField()) continue;
                ret.put(fi.getFieldName(), fi.getString("UTF-8"));
            }
            return ret;
        }
        catch (Exception e) {
            servlet.log("\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u53d7\u4fe1\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public void uploadFilePipe(ServletContext servlet, FileItem source, OutputStream target) {
        try {
            BufferedInputStream bin = new BufferedInputStream(source.getInputStream());
            byte[] b = new byte[1024];
            int n = 0;
            while ((n = bin.read(b, 0, b.length)) > 0) {
                target.write(b, 0, n);
            }
            target.flush();
        }
        catch (Exception e) {
            servlet.log("\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u66f8\u51fa\u3057\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
        }
    }

    protected void sendmail(String smtpIp, String smtpPort, String from, String[] to, String subject, String body) throws AddressException, MessagingException, UnsupportedEncodingException {
        Properties conf = new Properties();
        conf.put("mail.host", smtpIp);
        conf.put("mail.smtp.host", smtpIp);
        conf.put("mail.smtp.port", smtpPort);
        conf.put("mail.smtp.conectiontimeout", "60000");
        conf.put("mail.smtp.timeout", "180000");
        Session session = Session.getDefaultInstance((Properties)conf, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(from, "", "iso-2022-jp"));
        for (int i = 0; i < to.length; ++i) {
            InternetAddress toAddr = new InternetAddress(to[i]);
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)toAddr);
        }
        CalendarUtility calUtil = this.getCalUtil();
        mimeMessage.setSubject(subject, "ISO-2022-JP");
        mimeMessage.setHeader("Date", calUtil.formatCalendar(calUtil.getCalendar(), "EEE, d MMM yyyy H:m:s Z", Locale.ENGLISH));
        mimeMessage.setHeader("X-Mailer", "JavaMailer");
        mimeMessage.setHeader("Content-Type", "text/plain; charset=\"ISO-2022-JP\"");
        mimeMessage.setText(body, "ISO-2022-JP");
        Transport.send((Message)mimeMessage);
    }

    public void redirectError(HttpServletResponse res, String title, String message) throws IOException {
        PrintWriter out = res.getWriter();
        out.write("<html><script>\n");
        out.write("alert('" + title + "\\n" + message + "');\n");
        out.write("history.back();\n");
        out.write("</script><body></body></html>\n");
    }

    public String toExceptionHtml(Throwable e) {
        return this.toExceptionHtml(e, true);
    }

    private String toExceptionHtml(Throwable e, boolean isTag) {
        StringBuffer sb = new StringBuffer();
        if (isTag) {
            sb.append("<div align=\"left\"><pre>\n");
        }
        sb.append(e.getClass().toString());
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append("\n");
        StackTraceElement[] elem = e.getStackTrace();
        for (int i = 0; i < elem.length; ++i) {
            sb.append("\tat ");
            sb.append(elem[i].getClassName());
            sb.append("#");
            sb.append(elem[i].getMethodName());
            sb.append("(");
            String fn = elem[i].getFileName();
            if (fn != null) {
                sb.append(elem[i].getFileName());
                sb.append(":");
                sb.append(elem[i].getLineNumber());
            } else {
                sb.append("Unknown");
            }
            sb.append(")");
            sb.append("\n");
        }
        Throwable t = e.getCause();
        if (t != null) {
            sb.append("Cause by\n");
            sb.append(this.toExceptionHtml(t, false));
        }
        if (isTag) {
            sb.append("</pre></div>\n");
        }
        return sb.toString();
    }

    public abstract boolean isInit();
}

