/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.web.DefaultController;
import jp.nyx.pkg.ca.db.CaManager;
import jp.nyx.pkg.sso.db.SsoManager;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class BaseSettingController
extends DefaultController {
    public static final String ATTR_CAMANAGER = "caManager";
    public static final String ATTR_SSOMANAGER = "ssoManager";
    public static final String ATTR_CADATASOURCE = "caDataSource";
    public static final String ATTR_SSODATASOURCE = "ssoDataSource";
    private boolean caDsInit = false;
    private boolean ssoDsInit = false;

    private void caInit(ModelAndView mv) throws ServletException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NyxException, SQLException {
        WebApplicationContext appCtx = super.getWebApplicationContext();
        Map<String, Setting> nyx = this.getNyx(mv);
        DataSource ds = (DataSource)appCtx.getBean(ATTR_CADATASOURCE);
        Method m = ds.getClass().getMethod("setDriverClassName", String.class);
        m.invoke((Object)ds, nyx.get("ca_jdbc_driver").getValue());
        m = ds.getClass().getMethod("setUrl", String.class);
        m.invoke((Object)ds, nyx.get("ca_jdbc_url").getValue());
        m = ds.getClass().getMethod("setUsername", String.class);
        m.invoke((Object)ds, nyx.get("ca_jdbc_user").getValue());
        m = ds.getClass().getMethod("setPassword", String.class);
        m.invoke((Object)ds, nyx.get("ca_jdbc_pass").getValue());
        this.caDsInit = true;
    }

    private void ssoInit(ModelAndView mv) throws NyxException {
        WebApplicationContext appCtx = super.getWebApplicationContext();
        Map<String, Setting> nyx = this.getNyx(mv);
        BaseSettingController.ssoInit(appCtx, nyx);
        this.ssoDsInit = true;
    }

    protected static void ssoInit(WebApplicationContext appCtx, Map<String, Setting> nyx) throws NyxException {
        try {
            DataSource ds = (DataSource)appCtx.getBean(ATTR_SSODATASOURCE);
            Method m = ds.getClass().getMethod("setDriverClassName", String.class);
            m.invoke((Object)ds, nyx.get("sso_jdbc_driver").getValue());
            m = ds.getClass().getMethod("setUrl", String.class);
            m.invoke((Object)ds, nyx.get("sso_jdbc_url").getValue());
            m = ds.getClass().getMethod("setUsername", String.class);
            m.invoke((Object)ds, nyx.get("sso_jdbc_user").getValue());
            m = ds.getClass().getMethod("setPassword", String.class);
            m.invoke((Object)ds, nyx.get("sso_jdbc_pass").getValue());
            SsoManager ssoManager = (SsoManager)appCtx.getBean(ATTR_SSOMANAGER);
            ssoManager.init((ApplicationContext)appCtx);
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        if (!this.isAdminUser(request)) {
            this.webUtil.sendAuthenticate(request, response, null);
            return mv;
        }
        Map<String, String> status = this.getStatus(mv);
        Map<String, Setting> nyx = this.getNyx(mv);
        if ("ca_connect".equals(request.getParameter("mode"))) {
            try {
                Class<?> drvClass = Class.forName(nyx.get("ca_jdbc_driver").getValue());
                Driver drv = (Driver)drvClass.newInstance();
                Properties conf = new Properties();
                conf.put("user", nyx.get("ca_jdbc_user").getValue());
                conf.put("password", nyx.get("ca_jdbc_pass").getValue());
                Connection con = drv.connect(nyx.get("ca_jdbc_url").getValue(), conf);
                con.setAutoCommit(false);
                status.put("status", "success");
                DatabaseMetaData meta = con.getMetaData();
                status.put("DatabaseProductName", meta.getDatabaseProductName());
                status.put("DatabaseProductVersion", meta.getDatabaseProductVersion());
                status.put("DriverName", meta.getDriverName());
                status.put("DriverVersion", meta.getDriverVersion());
                StringBuffer sb = new StringBuffer();
                sb.append("\u63a5\u7d9a\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\n");
                sb.append("DatabaseProductName:").append(meta.getDatabaseProductName()).append("\n");
                sb.append("DatabaseProductVersion:").append(meta.getDatabaseProductVersion()).append("\n");
                sb.append("DriverName:").append(meta.getDriverName()).append("\n");
                sb.append("DriverVersion:").append(meta.getDriverVersion()).append("\n");
                status.put("message", sb.toString().replaceAll("\n", "<br/>"));
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if ("ca_init".equals(request.getParameter("mode"))) {
            try {
                if (!this.caDsInit) {
                    this.caInit(mv);
                }
                ApplicationContext appCtx = super.getApplicationContext();
                CaManager caManager = (CaManager)appCtx.getBean(ATTR_CAMANAGER);
                caManager.init(appCtx);
                nyx.get("ca_jdbc_driver").setMode("r");
                nyx.get("ca_jdbc_url").setMode("r");
                nyx.get("ca_jdbc_user").setMode("r");
                nyx.get("ca_jdbc_pass").setMode("r");
                nyx.get("ca_init_c").setMode("r");
                nyx.get("ca_init_st").setMode("r");
                nyx.get("ca_init_l").setMode("r");
                nyx.get("ca_init_o").setMode("r");
                nyx.get("ca_init_ou").setMode("r");
                nyx.get("ca_init_cn").setMode("r");
                nyx.get("ca_init_z_start").setMode("r");
                nyx.get("ca_init_z_end").setMode("r");
                nyx.get("ca_init_zzz").setMode("r");
                nyx.get("ca_init_reset").setMode("rw");
                caManager.initCA(appCtx, nyx);
                NyxManager mrg = this.getNyxManager(request);
                mrg.saveSetting(nyx);
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                return mv;
            }
            status.put("status", "success");
            status.put("message", "CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            return mv;
        }
        if ("ca_reset".equals(request.getParameter("mode"))) {
            try {
                nyx.get("ca_jdbc_driver").setMode("rw");
                nyx.get("ca_jdbc_url").setMode("rw");
                nyx.get("ca_jdbc_user").setMode("rw");
                nyx.get("ca_jdbc_pass").setMode("rw");
                nyx.get("ca_init_c").setMode("rw");
                nyx.get("ca_init_st").setMode("rw");
                nyx.get("ca_init_l").setMode("rw");
                nyx.get("ca_init_o").setMode("rw");
                nyx.get("ca_init_ou").setMode("rw");
                nyx.get("ca_init_cn").setMode("rw");
                nyx.get("ca_init_z_start").setMode("rw");
                nyx.get("ca_init_z_end").setMode("rw");
                nyx.get("ca_init_zzz").setMode("rw");
                nyx.get("ca_init_reset").setMode("r");
                NyxManager mrg = this.getNyxManager(request);
                mrg.saveSetting(nyx);
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u518d\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u518d\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                return mv;
            }
            status.put("status", "success");
            status.put("message", "CA\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u518d\u8a2d\u5b9a\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            return mv;
        }
        if ("sso_init".equals(request.getParameter("mode"))) {
            try {
                if (!this.ssoDsInit) {
                    this.ssoInit(mv);
                }
                nyx.get("sso_jdbc_driver").setMode("r");
                nyx.get("sso_jdbc_url").setMode("r");
                nyx.get("sso_jdbc_user").setMode("r");
                nyx.get("sso_jdbc_pass").setMode("r");
                nyx.get("sso_init_zzz").setMode("r");
                NyxManager mrg = this.getNyxManager(request);
                mrg.saveSetting(nyx);
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "SSO\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"SSO\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                return mv;
            }
            status.put("status", "success");
            status.put("message", "SSO\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u521d\u671f\u5316\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            return mv;
        }
        if ("sso_connect".equals(request.getParameter("mode"))) {
            try {
                Class<?> drvClass = Class.forName(nyx.get("sso_jdbc_driver").getValue());
                Driver drv = (Driver)drvClass.newInstance();
                Properties conf = new Properties();
                conf.put("user", nyx.get("sso_jdbc_user").getValue());
                conf.put("password", nyx.get("sso_jdbc_pass").getValue());
                Connection con = drv.connect(nyx.get("sso_jdbc_url").getValue(), conf);
                con.setAutoCommit(false);
                status.put("status", "success");
                DatabaseMetaData meta = con.getMetaData();
                status.put("DatabaseProductName", meta.getDatabaseProductName());
                status.put("DatabaseProductVersion", meta.getDatabaseProductVersion());
                status.put("DriverName", meta.getDriverName());
                status.put("DriverVersion", meta.getDriverVersion());
                StringBuffer sb = new StringBuffer();
                sb.append("\u63a5\u7d9a\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\n");
                sb.append("DatabaseProductName:").append(meta.getDatabaseProductName()).append("\n");
                sb.append("DatabaseProductVersion:").append(meta.getDatabaseProductVersion()).append("\n");
                sb.append("DriverName:").append(meta.getDriverName()).append("\n");
                sb.append("DriverVersion:").append(meta.getDriverVersion()).append("\n");
                status.put("message", sb.toString().replaceAll("\n", "<br/>"));
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if ("app_connect".equals(request.getParameter("mode"))) {
            try {
                Class<?> drvClass = Class.forName(nyx.get("app_jdbc_driver").getValue());
                Driver drv = (Driver)drvClass.newInstance();
                Properties conf = new Properties();
                conf.put("user", nyx.get("app_jdbc_user").getValue());
                conf.put("password", nyx.get("app_jdbc_pass").getValue());
                Connection con = drv.connect(nyx.get("app_jdbc_url").getValue(), conf);
                con.setAutoCommit(false);
                status.put("status", "success");
                DatabaseMetaData meta = con.getMetaData();
                status.put("DatabaseProductName", meta.getDatabaseProductName());
                status.put("DatabaseProductVersion", meta.getDatabaseProductVersion());
                status.put("DriverName", meta.getDriverName());
                status.put("DriverVersion", meta.getDriverVersion());
                StringBuffer sb = new StringBuffer();
                sb.append("\u63a5\u7d9a\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\n");
                sb.append("DatabaseProductName:").append(meta.getDatabaseProductName()).append("\n");
                sb.append("DatabaseProductVersion:").append(meta.getDatabaseProductVersion()).append("\n");
                sb.append("DriverName:").append(meta.getDriverName()).append("\n");
                sb.append("DriverVersion:").append(meta.getDriverVersion()).append("\n");
                status.put("message", sb.toString().replaceAll("\n", "<br/>"));
            }
            catch (Exception e) {
                status.put("status", "fail");
                status.put("message", "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if (!"update".equals(request.getParameter("mode"))) {
            return mv;
        }
        try {
            NyxManager mgr = this.getNyxManager(request);
            Setting setting = nyx.get(request.getParameter("name"));
            setting.setValue(request.getParameter("value"));
            mgr.saveSetting(nyx);
            status.put("status", "success");
            status.put("message", "\u8a2d\u5b9a\u304c\u4fdd\u5b58\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            status.put("status", "fail");
            status.put("message", e.getMessage());
        }
        return mv;
    }
}

