/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.spec;

import java.net.URL;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.common.util.WebUtility;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class AccessValidaterUtility
extends WebUtility {
    private NyxManager nyxManager;

    public AccessValidaterUtility(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    public boolean checkAuth(DataSource ds, String requestUrl, String requestUri, String queryString) throws NyxException {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(ds);
        try {
            URL trigger = this.createRequestURL(requestUrl, requestUri, queryString);
            if (trigger == null) {
                throw new IllegalArgumentException("param.getTrigger_site()==null");
            }
            List<Map<String, Object>> result = this.loadAuth(template, trigger);
            return result.size() > 0;
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    public boolean valid(DataSource ds, HttpServletRequest request, AuthValue ret) throws NyxException {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(ds);
        try {
            URL trigger = this.createRequestURL(request);
            if (trigger == null) {
                throw new IllegalArgumentException("param.getTrigger_site()==null");
            }
            ret.setTriggerSite(trigger);
            ret.setTriggerMethod(request.getMethod());
            ret.setClientAddress(request.getRemoteAddr());
            ret.setUserId(this.parseRequestUser(request));
            ret.setPasswd(this.parseRequestPasswd(request));
            List<Map<String, Object>> result = this.loadAuth(template, trigger);
            Iterator<Map<String, Object>> i$ = result.iterator();
            if (i$.hasNext()) {
                Map<String, Object> row = i$.next();
                long auth_id = this.numUtil.parseLong(row.get("auth_id"));
                String auth_name = (String)row.get("auth_name");
                String auth_type = (String)row.get("auth_type");
                String auth_use = (String)row.get("auth_use");
                ret.setAuthId(auth_id);
                ret.setAuthName(auth_name);
                ret.setAuthType(auth_type);
                ret.setAuthUse(auth_use);
                Long valid_site_id = this.numUtil.parseLong(row.get("valid_site_id"));
                Long failer_site_id = this.numUtil.parseLong(row.get("failer_site_id"));
                this.searchValidSite(ret, template, valid_site_id, failer_site_id);
                if (ret.getValidSite() != null) {
                    ret.getLog().append("[Auth-Success]");
                    return true;
                }
            }
            if (result.size() <= 0) {
                ret.getLog().append("[NotFound-TriggerSite]");
            } else {
                ret.getLog().append("[NoMatch-TriggerSite]");
            }
            return false;
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    private List<Map<String, Object>> loadAuth(SimpleJdbcTemplate template, URL trigger) throws SQLException {
        List result = this.nyxManager.isPostgreSQL() ? template.queryForList("select auth_id, valid_site_id, auth_name, failer_site_id, auth_type, auth_use from v_auth_verify where ? like site_path||'%' order by char_length(site_path) desc, auth_id desc", new Object[]{trigger.getPath()}) : template.queryForList("select auth_id as \"auth_id\", valid_site_id as \"valid_site_id\", auth_name as \"auth_name\", failer_site_id as \"failer_site_id\", auth_type as \"auth_type\", auth_use as \"auth_use\" from v_auth_verify where ? like site_path||'%' order by length(site_path) desc, \"auth_id\" desc", new Object[]{trigger.getPath()});
        return result;
    }

    private void searchValidSite(AuthValue ret, SimpleJdbcTemplate template, Long valid_site_id, Long failer_site_id) throws NyxException {
        try {
            URL trigger = ret.getTriggerSite();
            StringBuffer authLog = ret.getLog();
            authLog.append(ret.getAuthName());
            authLog.append(" ");
            String auth_type = ret.getAuthType();
            if (Auth.AuthType.PASSED.getText().equals(auth_type)) {
                ret.setValidSite(this.loadSiteUrl(template, valid_site_id, trigger));
                return;
            }
            if (Auth.AuthType.isOpenidType((String)auth_type)) {
                // empty if block
            }
            int crs1 = template.queryForInt("select count(*) from v_auth_context_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.getAuthId(), ret.getUserId(), DigestUtility.md5((String)ret.getPasswd())});
            int crs2 = template.queryForInt("select count(*) from v_auth_context_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.getAuthId(), ret.getUserId(), DigestUtility.sha1((String)ret.getPasswd())});
            if (crs1 <= 0 && crs2 <= 0) {
                int urs1 = template.queryForInt("select count(*) from v_auth_user_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.getAuthId(), ret.getUserId(), DigestUtility.md5((String)ret.getPasswd())});
                int urs2 = template.queryForInt("select count(*) from v_auth_user_verify where auth_id=? and user_id=? and passwd=? ", new Object[]{ret.getAuthId(), ret.getUserId(), DigestUtility.sha1((String)ret.getPasswd())});
                if (urs1 <= 0 && urs2 <= 0) {
                    authLog.append("[NotFound-UserOnTrigger]");
                    ret.setFailerSite(this.loadSiteUrl(template, failer_site_id, trigger));
                    return;
                }
            }
            ret.setValidSite(this.loadSiteUrl(template, valid_site_id, trigger));
            if (ret.getValidSite() == null) {
                authLog.append("[NotFound-ValidSite]");
                ret.setFailerSite(this.loadSiteUrl(template, failer_site_id, trigger));
                return;
            }
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    private URL loadSiteUrl(SimpleJdbcTemplate template, Long siteId, URL trigger) throws NyxException {
        try {
            if (siteId == null) {
                return null;
            }
            Map row = template.queryForMap("select site_protocol as \"site_protocol\", site_host as \"site_host\", site_port as \"site_port\", site_path as \"site_path\" from m_site where site_id=? and site_path is not null", new Object[]{siteId});
            if (row == null) {
                return null;
            }
            String queryString = trigger.getQuery();
            return new URL((String)row.get("site_protocol"), (String)row.get("site_host"), (Integer)row.get("site_port"), trigger.getPath() + (queryString != null && !"".equals(queryString) ? "?" + queryString : ""));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            throw new NyxException((Throwable)e);
        }
    }

    public class AuthValue {
        private String userId = null;
        private URL triggerSite = null;
        private String triggerMethod = null;
        private String passwd = null;
        private long authId = -1L;
        private String authName = null;
        private String authType = null;
        private String authUse = null;
        private URL validSite = null;
        private URL failerSite = null;
        private String clientAddress = null;
        private StringBuffer log = new StringBuffer();
        private long lastAccess = -1L;
        private boolean proxyLogWrite = false;
        private String sessionId = null;

        public void clean() {
            this.userId = null;
            this.triggerSite = null;
            this.triggerMethod = null;
            this.passwd = null;
            this.authId = -1L;
            this.authName = null;
            this.authType = null;
            this.authUse = null;
            this.validSite = null;
            this.failerSite = null;
            this.clientAddress = null;
            this.log = new StringBuffer();
            this.proxyLogWrite = false;
        }

        public long getAuthId() {
            return this.authId;
        }

        public void setAuthId(long authId) {
            this.authId = authId;
        }

        public String getClientAddress() {
            return this.clientAddress;
        }

        public void setClientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
        }

        public URL getFailerSite() {
            return this.failerSite;
        }

        public void setFailerSite(URL failerSite) {
            this.failerSite = failerSite;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }

        public URL getTriggerSite() {
            return this.triggerSite;
        }

        public void setTriggerSite(URL triggerSite) {
            this.triggerSite = triggerSite;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public URL getValidSite() {
            return this.validSite;
        }

        public void setValidSite(URL validSite) {
            this.validSite = validSite;
        }

        public StringBuffer getLog() {
            return this.log;
        }

        public String getAuthName() {
            return this.authName;
        }

        public void setAuthName(String authName) {
            this.authName = authName;
        }

        public String getAuthType() {
            return this.authType;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        public String getAuthUse() {
            return this.authUse;
        }

        public void setAuthUse(String authUse) {
            this.authUse = authUse;
        }

        public String getTriggerMethod() {
            return this.triggerMethod;
        }

        public void setTriggerMethod(String triggerMethod) {
            this.triggerMethod = triggerMethod;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long lastAccess) {
            this.lastAccess = lastAccess;
        }

        public boolean isProxyLogWrite() {
            return this.proxyLogWrite;
        }

        public void setProxyLogWrite(boolean proxyLogWrite) {
            this.proxyLogWrite = proxyLogWrite;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

