/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.User;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class ViewController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        ssoManager.init((ApplicationContext)super.getWebApplicationContext());
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        Map<String, String> status = this.getStatus(mv);
        if (this.webUtil.textUtil.isEmpty(request.getParameter("mode"))) {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u30e2\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff09");
            return mv;
        }
        String mode = request.getParameter("mode");
        if ("user".equals(mode)) {
            this.loadUserView(request, mv, ssoManager, status);
        } else if ("context".equals(mode)) {
            this.loadContextView(request, mv, ssoManager, status);
        } else if ("auth".equals(mode)) {
            this.loadAuthView(request, mv, ssoManager, status);
        } else if ("site".equals(mode)) {
            this.loadSiteView(request, mv, ssoManager, status);
        } else {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u30e2\u30fc\u30c9\u304c\u4e0d\u660e\u3067\u3059\uff09");
            return mv;
        }
        return mv;
    }

    private void loadUserView(HttpServletRequest request, ModelAndView mv, SsoManager ssoManager, Map<String, String> status) throws NyxException {
        String user_id = request.getParameter("user_id");
        TreeSet<User> users = new TreeSet<User>();
        Set<Object> contexts = new TreeSet();
        Set<Object> auths = new TreeSet();
        TreeSet<Site> sites = new TreeSet<Site>();
        User user = ssoManager.loadUser(user_id);
        if (user == null) {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u6307\u5b9a\u3055\u308c\u305f\u30e6\u30fc\u30b6\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + user_id + "]\uff09");
            return;
        }
        users.add(user);
        contexts = ssoManager.loadContext(user_id);
        auths = ssoManager.loadAuthUser(user_id);
        for (Context context : contexts) {
            Set<Auth> as = ssoManager.loadAuthContext(context.getContextCode());
            auths.addAll(as);
        }
        for (Auth auth : auths) {
            Set apps = auth.getAppSiteId();
            for (Site s : apps) {
                sites.add(ssoManager.loadSite(s.getSiteId()));
            }
            auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
        }
        mv.getModel().put("users", users);
        mv.getModel().put("contexts", contexts);
        mv.getModel().put("auths", auths);
        mv.getModel().put("sites", sites);
    }

    private void loadContextView(HttpServletRequest request, ModelAndView mv, SsoManager ssoManager, Map<String, String> status) throws NyxException {
        String context_code = request.getParameter("context_code");
        TreeSet<User> users = new TreeSet<User>();
        TreeSet<Context> contexts = new TreeSet<Context>();
        Set<Object> auths = new TreeSet();
        TreeSet<Site> sites = new TreeSet<Site>();
        Context context = ssoManager.loadContext(this.webUtil.numUtil.parseLong((Object)context_code));
        if (context == null) {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u6307\u5b9a\u3055\u308c\u305f\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + context_code + "]\uff09");
            return;
        }
        contexts.add(context);
        for (User user : context.getUser()) {
            users.add(ssoManager.loadUser(user.getUserId()));
        }
        auths = ssoManager.loadAuthContext(context.getContextCode());
        for (Auth auth : auths) {
            Set apps = auth.getAppSiteId();
            for (Site s : apps) {
                sites.add(ssoManager.loadSite(s.getSiteId()));
            }
            auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
        }
        mv.getModel().put("users", users);
        mv.getModel().put("contexts", contexts);
        mv.getModel().put("auths", auths);
        mv.getModel().put("sites", sites);
    }

    private void loadAuthView(HttpServletRequest request, ModelAndView mv, SsoManager ssoManager, Map<String, String> status) throws NyxException {
        String auth_id = request.getParameter("auth_id");
        TreeSet<User> users = new TreeSet<User>();
        TreeSet<Context> contexts = new TreeSet<Context>();
        TreeSet<Auth> auths = new TreeSet<Auth>();
        TreeSet<Site> sites = new TreeSet<Site>();
        Auth auth = ssoManager.loadAuth(this.webUtil.numUtil.parseLong((Object)auth_id));
        if (auth == null) {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u6307\u5b9a\u3055\u308c\u305f\u6a29\u9650\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + auth_id + "]\uff09");
            return;
        }
        auths.add(auth);
        for (User u : auth.getUser()) {
            users.add(ssoManager.loadUser(u.getUserId()));
        }
        for (Context c : auth.getContext()) {
            Context ctx = ssoManager.loadContext(c.getContextCode());
            contexts.add(ctx);
            for (User u : ctx.getUser()) {
                users.add(ssoManager.loadUser(u.getUserId()));
            }
        }
        Set apps = auth.getAppSiteId();
        for (Site s : apps) {
            if (sites.contains(s)) continue;
            sites.add(ssoManager.loadSite(s.getSiteId()));
        }
        auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
        mv.getModel().put("users", users);
        mv.getModel().put("contexts", contexts);
        mv.getModel().put("auths", auths);
        mv.getModel().put("sites", sites);
    }

    private void loadSiteView(HttpServletRequest request, ModelAndView mv, SsoManager ssoManager, Map<String, String> status) throws NyxException {
        String site_id = request.getParameter("site_id");
        TreeSet<User> users = new TreeSet<User>();
        TreeSet<Context> contexts = new TreeSet<Context>();
        Set<Object> auths = new TreeSet();
        TreeSet<Site> sites = new TreeSet<Site>();
        Site site = ssoManager.loadSite(this.webUtil.numUtil.parseLong((Object)site_id));
        if (site == null) {
            status.put("message", "\u30d3\u30e5\u30fc\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff08\u6307\u5b9a\u3055\u308c\u305f\u30b5\u30a4\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + site_id + "]\uff09");
            return;
        }
        sites.add(site);
        auths = ssoManager.loadAuthAppSite(site.getSiteId());
        Set<Auth> vauth = ssoManager.loadAuthValidSite(site.getSiteId());
        Set<Auth> fauth = ssoManager.loadAuthFailSite(site.getSiteId());
        for (Auth auth : vauth) {
            auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
            auths.add(auth);
        }
        for (Auth auth : fauth) {
            auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
            auths.add(auth);
        }
        for (Auth auth : auths) {
            for (User u : auth.getUser()) {
                users.add(ssoManager.loadUser(u.getUserId()));
            }
            for (Context c : auth.getContext()) {
                Context ctx = ssoManager.loadContext(c.getContextCode());
                contexts.add(ctx);
                for (User u : ctx.getUser()) {
                    users.add(ssoManager.loadUser(u.getUserId()));
                }
            }
            auth.setTriggerSiteId(ssoManager.loadSite(auth.getTriggerSiteIdInt()));
        }
        mv.getModel().put("users", users);
        mv.getModel().put("contexts", contexts);
        mv.getModel().put("auths", auths);
        mv.getModel().put("sites", sites);
    }
}

