/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.BERGenerator;
import org.bouncycastle.asn1.DEROctetString;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream outputStream, int n, boolean bl) throws IOException {
        super(outputStream, n, bl);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return new BEROctetStream();
    }

    public OutputStream getOctetOutputStream(byte[] byArray) {
        return new BufferedBEROctetStream(byArray);
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;

        BufferedBEROctetStream(byte[] byArray) {
            this._buf = byArray;
            this._off = 0;
        }

        @Override
        public void write(int n) throws IOException {
            this._buf[this._off++] = (byte)n;
            if (this._off == this._buf.length) {
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
            }
        }

        @Override
        public void close() throws IOException {
            if (this._off != 0) {
                byte[] byArray = new byte[this._off];
                System.arraycopy(this._buf, 0, byArray, 0, this._off);
                BEROctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }

    private class BEROctetStream
    extends OutputStream {
        private byte[] _buf = new byte[1];

        private BEROctetStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this._buf[0] = (byte)n;
            BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            BEROctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            BEROctetStringGenerator.this._out.write(new DEROctetString(byArray2).getEncoded());
        }

        @Override
        public void close() throws IOException {
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

