/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.util.Iterator;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUtils;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.acegisecurity.providers.ldap.authenticator.LdapShaPasswordEncoder;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator == null ? (class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator = PasswordComparisonAuthenticator.class$("org.acegisecurity.providers.ldap.authenticator.PasswordComparisonAuthenticator")) : class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator));
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();
    private String passwordAttributeName = "userPassword";
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$authenticator$PasswordComparisonAuthenticator;

    public PasswordComparisonAuthenticator(InitialDirContextFactory initialDirContextFactory) {
        super(initialDirContextFactory);
    }

    public LdapUserDetails authenticate(String username, String password) {
        UserDetails user = null;
        Iterator dns = this.getUserDns(username).iterator();
        LdapTemplate ldapTemplate = new LdapTemplate(this.getInitialDirContextFactory());
        while (dns.hasNext() && user == null) {
            String userDn = (String)dns.next();
            if (!ldapTemplate.nameExists(userDn)) continue;
            LdapUserDetailsImpl.Essence userEssence = (LdapUserDetailsImpl.Essence)ldapTemplate.retrieveEntry(userDn, this.getUserDetailsMapper(), this.getUserAttributes());
            userEssence.setUsername(username);
            user = userEssence.createUserDetails();
        }
        if (user == null && this.getUserSearch() != null) {
            user = this.getUserSearch().searchForUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        String retrievedPassword = user.getPassword();
        if (retrievedPassword != null) {
            if (!this.verifyPassword(password, retrievedPassword)) {
                throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
            }
            return user;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Password attribute wasn't retrieved for user '" + username + "' using mapper " + this.getUserDetailsMapper() + ". Performing LDAP compare of password attribute '" + this.passwordAttributeName + "'"));
        }
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        byte[] passwordBytes = LdapUtils.getUtf8Bytes(encodedPassword);
        if (!ldapTemplate.compare(user.getDn(), this.passwordAttributeName, passwordBytes)) {
            throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }

    private boolean verifyPassword(String password, String ldapPassword) {
        if (ldapPassword.equals(password)) {
            return true;
        }
        return this.passwordEncoder.isPasswordValid(ldapPassword, password, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

