/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.common.taglib.db.forum;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jp.nyx.NyxException;
import jp.nyx.pkg.swc.db.SwcWeb;

public class ForumWeb
extends SwcWeb {
    public void init(HttpServletRequest request, ServletContext context) throws NyxException, IOException {
        super.init(request, context);
    }

    public boolean isCategoryOwner(int category_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_category_owner where category_id=? and user_id=?", new Object[]{category_id, this.getRemoteUser()});
        return ret.size() > 0;
    }

    public boolean isForumOwner(int forum_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_forum_owner where forum_id=? and user_id=?", new Object[]{forum_id, this.getRemoteUser()});
        return ret.size() > 0;
    }

    public boolean isForumMember(int forum_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_forum_member where forum_id=? and user_id=?", new Object[]{forum_id, this.getRemoteUser()});
        return ret.size() > 0;
    }

    public boolean isTopicOwner(int topic_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_topic_owner where topic_id=? and user_id=?", new Object[]{topic_id, this.getRemoteUser()});
        return ret.size() > 0;
    }

    public boolean isTopicMember(int topic_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_topic_member where topic_id=? and user_id=?", new Object[]{topic_id, this.getRemoteUser()});
        return ret.size() > 0;
    }

    public Map<String, Object> loadTopicMember(int category_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_category where category_id=?", new Object[]{category_id});
        return ret;
    }

    public Map<String, Object> loadForum(int forum_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_forum where forum_id=?", new Object[]{forum_id});
        return ret;
    }

    public Map<String, Object> loadTopic(int topic_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_topic where topic_id=?", new Object[]{topic_id});
        return ret;
    }

    public Map<String, Object> loadPost(int post_id) {
        Map ret = this.getAppManager().loadMap("select * from forum_post where post_id=?", new Object[]{post_id});
        return ret;
    }

    public boolean isForumAddUser(int category_id) {
        return this.isCategoryOwner(category_id);
    }

    public boolean isTopicAddUser(int forum_id, int topic_id) {
        boolean ret = true;
        boolean own = this.isForumOwner(forum_id);
        boolean mem = this.isForumMember(forum_id);
        Map<String, Object> forum = this.loadForum(forum_id);
        Map<String, Object> topic = this.loadTopic(topic_id);
        ret = "viewonly".equals(forum.get("forum_status")) ? false : ret;
        ret = "hidden".equals(forum.get("forum_status")) ? false : ret;
        ret = "owner".equals(topic.get("topic_newmode")) ? false : ret;
        ret = !mem && "member".equals(topic.get("topic_newmode")) ? false : ret;
        ret = own ? true : ret;
        return ret;
    }

    public boolean isPostAddUser(int topic_id) {
        boolean ret = true;
        boolean own = this.isTopicOwner(topic_id);
        boolean mem = this.isTopicMember(topic_id);
        Map<String, Object> topic = this.loadTopic(topic_id);
        ret = "viewonly".equals(topic.get("topic_status")) ? false : ret;
        ret = "hidden".equals(topic.get("topic_status")) ? false : ret;
        ret = "owner".equals(topic.get("topic_newmode")) ? false : ret;
        ret = !mem && "member".equals(topic.get("post_newmode")) ? false : ret;
        ret = own ? true : ret;
        return ret;
    }

    public boolean isForumEditUser(int category_id, int forum_id) {
        boolean ret = true;
        boolean catOwn = this.isCategoryOwner(category_id);
        boolean forOwn = this.isForumOwner(forum_id);
        ret = catOwn || forOwn ? true : ret;
        return ret;
    }

    public boolean isTopicEditUser(int forum_id, int topic_id) {
        boolean ret = true;
        boolean forOwn = this.isForumOwner(forum_id);
        boolean topOwn = this.isTopicOwner(topic_id);
        boolean mem = this.isTopicMember(topic_id);
        Map<String, Object> forum = this.loadForum(forum_id);
        Map<String, Object> topic = this.loadTopic(topic_id);
        ret = "viewonly".equals(topic.get("topic_status")) ? false : ret;
        ret = "hidden".equals(topic.get("topic_status")) ? false : ret;
        ret = "owner".equals(forum.get("topic_editmode")) ? false : ret;
        ret = !mem && "member".equals(forum.get("topic_editmode")) ? false : ret;
        ret = forOwn || topOwn ? true : ret;
        return ret;
    }

    public boolean isPostEditUser(int topic_id, int post_id) {
        boolean ret = true;
        boolean topOwn = this.isTopicOwner(topic_id);
        boolean mem = this.isTopicMember(topic_id);
        Map<String, Object> post = this.loadPost(post_id);
        boolean postOwn = post.get("user_id").equals(this.getRemoteUser());
        Map<String, Object> topic = this.loadTopic(topic_id);
        ret = "viewonly".equals(post.get("post_status")) ? false : ret;
        ret = "hidden".equals(post.get("post_status")) ? false : ret;
        ret = "owner".equals(topic.get("post_editmode")) ? false : ret;
        ret = "user".equals(topic.get("post_editmode")) ? false : ret;
        ret = !mem && "member".equals(topic.get("post_editmode")) ? false : ret;
        ret = topOwn || postOwn ? true : ret;
        return ret;
    }

    public boolean isForumViewUser(int category_id, int forum_id) {
        boolean ret = true;
        boolean catOwn = this.isCategoryOwner(category_id);
        boolean forOwn = this.isForumOwner(forum_id);
        boolean mem = this.isForumMember(forum_id);
        Map<String, Object> forum = this.loadForum(forum_id);
        ret = "hidden".equals(forum.get("forum_status")) ? false : ret;
        ret = !mem && "member".equals(forum.get("forum_viewmode")) ? false : ret;
        ret = catOwn || forOwn ? true : ret;
        return ret;
    }

    public boolean isTopicViewUser(int forum_id, int topic_id) {
        boolean ret = true;
        boolean forOwn = this.isForumOwner(forum_id);
        boolean topOwn = this.isTopicOwner(topic_id);
        boolean mem = this.isTopicMember(topic_id);
        Map<String, Object> topic = this.loadTopic(topic_id);
        ret = "hidden".equals(topic.get("topic_status")) ? false : ret;
        ret = !mem && "member".equals(topic.get("topic_viewmode")) ? false : ret;
        ret = forOwn || topOwn ? true : ret;
        return ret;
    }

    public boolean isPostViewUser(int topic_id, int post_id) {
        boolean ret = true;
        boolean topOwn = this.isTopicOwner(topic_id);
        Map<String, Object> post = this.loadPost(post_id);
        boolean postOwn = post.get("user_id").equals(this.getRemoteUser());
        ret = "hidden".equals(post.get("post_status")) ? false : ret;
        ret = topOwn || postOwn ? true : ret;
        return ret;
    }

    public boolean isViewPostForTopic(int topic_id) {
        List ret = this.getAppManager().loadList("select p1.post_id as post_id from forum_post p1 left join (select post_id from forum_post_viewinfo where user_id=? and view_status='view' ) p2 on (p1.post_id=p2.post_id) where p2.post_id is null and p1.topic_id=?", new Object[]{this.getRemoteUser(), topic_id});
        return ret.size() > 0;
    }

    public boolean isViewPostForForum(int forum_id) {
        List ret = this.getAppManager().loadList("select t.topic_id, p.post_id from t_topic t, (select p1.topic_id as topic_id, p1.post_id as post_id from forum_post p1 left join (select post_id from forum_post_viewinfo where user_id=? and view_status='view' ) p2 on (p1.post_id=p2.post_id) where p2.post_id is null) p where t.topic_id=p.topic_id and forum_id=?", new Object[]{this.getRemoteUser(), forum_id});
        return ret.size() > 0;
    }

    public void updateForumLastUpUser(int forum_id) {
        this.getAppManager().update("update forum_forum set last_update=now(), last_update_user_id=? where forum_id=?", new Object[]{this.getRemoteUser(), forum_id});
    }

    public void updateTopicLastUpUser(int topic_id) {
        this.getAppManager().update("update forum_topic set last_update=now(), last_update_user_id=? where topic_id=?", new Object[]{this.getRemoteUser(), topic_id});
    }

    public void updatePostViewInfo(int topic_id) {
        List list = this.getAppManager().loadList("select post_id from forum_post where topic_id=?", new Object[]{topic_id});
        for (Map map : list) {
            this.getAppManager().update("delete from forum_post_viewinfo where post_id=? and user_id=?", new Object[]{map.get("post_id"), this.getRemoteUser()});
            this.getAppManager().update("insert into forum_post_viewinfo(post_id, user_id) values(?, ?)", new Object[]{map.get("post_id"), this.getRemoteUser()});
        }
    }
}

