/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.sreg;

import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.ParameterList;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class SRegMessage
implements MessageExtension,
MessageExtensionFactory {
    private static Logger _log = Logger.getLogger((Class)SRegMessage.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String OPENID_NS_SREG = "http://openid.net/sreg/1.0";
    protected ParameterList _parameters;

    public SRegMessage() {
        this._parameters = new ParameterList();
        if (DEBUG) {
            _log.debug((Object)"Created empty SRegMessage.");
        }
    }

    public SRegMessage(ParameterList params) {
        this._parameters = params;
        if (DEBUG) {
            _log.debug((Object)("Created SRegMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_SREG;
    }

    public ParameterList getParameters() {
        return this._parameters;
    }

    public String getParameterValue(String name) {
        return this._parameters.getParameterValue(name);
    }

    public void setParameters(ParameterList params) {
        this._parameters = params;
    }

    public String multivalEncode(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
    }

    public String multivalDecode(String value) {
        return value.replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public boolean providesIdentifier() {
        return false;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter("required") || parameterList.hasParameter("optional")) {
            return SRegRequest.createSRegRequest(parameterList);
        }
        return SRegResponse.createSRegResponse(parameterList);
    }
}

