/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.common.db.NyxDao;
import jp.nyx.common.db.Setting;
import jp.nyx.common.util.WebUtility;

public class NyxManager {
    private NyxDao dao;
    private Map<String, Setting> nyx;
    public final WebUtility webUtil = new WebUtility();

    public void setNyxDao(NyxDao dao) {
        this.dao = dao;
    }

    public void init() throws SQLException {
        int c;
        List<Map<String, Object>> line;
        String ck;
        Matcher m;
        if (this.dao.isInit()) {
            return;
        }
        ResourceBundle conf = ResourceBundle.getBundle("jp.nyx.common.db.nyx_sql");
        Set<String> keys = conf.keySet();
        Pattern create = Pattern.compile("sql\\.create\\.(.+)");
        Pattern update = Pattern.compile("sql\\.update\\.(.+)");
        for (String k : keys) {
            m = create.matcher(k);
            if (!m.find()) continue;
            ck = m.group(1);
            try {
                line = this.dao.query(conf.getString("sql.check." + ck).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck), new Object[0]);
                c = this.webUtil.numUtil.parseInt(line.get(0).get("c").toString(), 0);
                if (c > 0) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.dao.update(conf.getString(k).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck));
        }
        for (String k : keys) {
            m = update.matcher(k);
            if (!m.find()) continue;
            ck = m.group(1);
            try {
                line = this.dao.query(conf.getString("sql.check." + ck).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck), new Object[0]);
                c = this.webUtil.numUtil.parseInt(line.get(0).get("c").toString(), 0);
                if (c > 0) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.dao.update(conf.getString(k).replaceAll("<semicolon>", ";").replaceAll("\\$\\{_key\\}", ck));
        }
    }

    public Map<String, Setting> loadSetting() throws SQLException {
        if (this.nyx != null) {
            return this.nyx;
        }
        this.nyx = this.dao.loadSetting();
        return this.nyx;
    }

    public void saveSetting(Map<String, Setting> setting) {
        this.dao.saveSetting(setting);
    }

    public boolean isPostgreSQL() throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return "postgresql".equals(nyx.get("ca_jdbc_type").getValue());
    }

    public boolean isDerby() throws SQLException {
        Map<String, Setting> nyx = this.loadSetting();
        return !"postgresql".equals(nyx.get("ca_jdbc_type").getValue());
    }
}

