/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.io.Serializable;
import jp.nyx.common.util.TextUtility;

public class Setting
implements Serializable {
    private static final long serialVersionUID = 7625502244837792714L;
    public static final String DEFAULT_MODE = "rw";
    public static final String DEFAULT_MODIFY = "text";
    private transient TextUtility textUtil = new TextUtility();
    private String name;
    private String parent;
    private String mode = "rw";
    private String modify = "text";
    private String value;
    private String display;

    public Setting() {
    }

    protected Setting(String name, String parent, String mode, String modify, String value, String display) {
        this.setName(name);
        this.setParent(parent);
        this.setMode(mode);
        this.setModify(modify);
        this.setValue(value);
        this.setDisplay(display);
    }

    public String getDisplay() {
        return this.display;
    }

    public String getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public String getModify() {
        return this.modify;
    }

    public boolean isSelectModify() {
        return this.modify.startsWith("select:");
    }

    public String getSelectModifyName() {
        return this.modify.substring("select:".length());
    }

    public void setDisplay(String display) {
        if (this.textUtil.isEmpty(display)) {
            throw new NullPointerException("display is null.");
        }
        this.display = display;
    }

    public void setMode(String mode) {
        if (this.textUtil.isEmpty(mode)) {
            throw new NullPointerException("mode is null.");
        }
        this.mode = mode;
    }

    public void setName(String name) {
        if (this.textUtil.isEmpty(name)) {
            throw new NullPointerException("name is null.");
        }
        this.name = name;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setModify(String modify) {
        this.modify = modify;
    }
}

