/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NyxSimpleFormatter
extends Formatter {
    public static final DateFormat format = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");

    @Override
    public String format(LogRecord recode) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(recode.getMillis());
        StringBuffer buf = new StringBuffer();
        String msg = recode.getMessage();
        Throwable throwable = recode.getThrown();
        buf.append("[");
        buf.append(recode.getLevel().toString());
        buf.append("] ");
        buf.append(format.format(cal.getTime()));
        buf.append(" th=");
        buf.append(recode.getThreadID());
        if (msg != null) {
            buf.append(": ");
            buf.append(msg);
        }
        if (throwable != null) {
            NyxSimpleFormatter.outThrowable(buf, throwable);
        }
        buf.append("\n");
        return buf.toString();
    }

    public static void outThrowable(StringBuffer sb, Throwable th) {
        sb.append("\n");
        sb.append(th.getClass().getName());
        sb.append(": ");
        sb.append(th.getMessage());
        sb.append("\n");
        StackTraceElement[] elem = th.getStackTrace();
        for (int i = 0; i < elem.length; ++i) {
            sb.append("\tat ");
            sb.append(elem[i].getClassName());
            sb.append('.');
            sb.append(elem[i].getMethodName());
            sb.append('(');
            sb.append(elem[i].getFileName());
            sb.append(':');
            sb.append(elem[i].getLineNumber());
            sb.append(")\n");
        }
        Throwable cause = th.getCause();
        if (cause == null) {
            return;
        }
        sb.append("Caused by: ");
        NyxSimpleFormatter.outThrowable(sb, cause);
    }
}

