/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.nyx.common.util.TextUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtility {
    private TextUtility txtUtil = new TextUtility();
    private DocumentBuilder domBuilder;

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.domBuilder != null) {
            return this.domBuilder;
        }
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        f.setValidating(false);
        f.setExpandEntityReferences(false);
        this.domBuilder = f.newDocumentBuilder();
        this.domBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource source = new InputSource(new StringReader(""));
                return source;
            }
        });
        return this.domBuilder;
    }

    public Document createNewDocument() throws ParserConfigurationException {
        return this.getDocumentBuilder().newDocument();
    }

    public Document parseDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        if (input == null) {
            return null;
        }
        return this.getDocumentBuilder().parse(input);
    }

    public Document parseDocument(Reader input) throws SAXException, IOException, ParserConfigurationException {
        if (input == null) {
            return null;
        }
        return this.getDocumentBuilder().parse(new InputSource(input));
    }

    public Element parseElement(String tagString) throws ParserConfigurationException, SAXException, IOException {
        return this.parseDocument(new StringReader(tagString)).getDocumentElement();
    }

    public Text getIndent(Node elem, boolean nestedIndent) {
        if (elem == null) {
            return null;
        }
        if (elem instanceof Document) {
            return ((Document)elem).createTextNode("");
        }
        Node n = elem.getPreviousSibling();
        if (n instanceof Element) {
            return this.getIndent(n, nestedIndent);
        }
        if (n == null) {
            Node p = elem.getParentNode();
            if (p != null) {
                return this.getIndent(p, nestedIndent);
            }
            return elem.getOwnerDocument().createTextNode("");
        }
        String v = n.getNodeValue();
        v = v == null ? "" : v;
        v = v.replaceAll("[\\r\\n]+", "\n");
        int sn = v.replaceAll("[\\t\\n]", "").length();
        for (int i = 0; i < sn / 4; ++i) {
            v = v + "\t";
        }
        v = v.replaceAll("[^\\t\\n]", "");
        v = nestedIndent ? v + "\t" : v;
        return elem.getOwnerDocument().createTextNode(v.toString());
    }

    public Text appendText(Element elem, String text) {
        if (elem == null) {
            return null;
        }
        Text t = elem.getOwnerDocument().createTextNode(text);
        elem.appendChild(t);
        return t;
    }

    public Element appendElement(Element elem, String localName, String prefix, String namespaceUri) {
        if (elem == null) {
            return null;
        }
        if (this.txtUtil.isEmpty(localName)) {
            return null;
        }
        String targetPrefix = null;
        String targetUri = null;
        if (!this.txtUtil.isEmpty(prefix) && this.txtUtil.isEmpty(namespaceUri)) {
            targetPrefix = prefix + ":";
            targetUri = namespaceUri;
        } else {
            targetPrefix = elem.getPrefix();
            targetPrefix = this.txtUtil.isEmpty(targetPrefix) ? "" : targetPrefix + ":";
            targetUri = elem.getNamespaceURI();
        }
        Element t = elem.getOwnerDocument().createElementNS(targetUri, targetPrefix + localName);
        elem.appendChild(t);
        return t;
    }

    public Element findFirstParentElement(Element elem) {
        if (elem == null) {
            return null;
        }
        for (Node p = elem.getParentNode(); p != null; p = p.getParentNode()) {
            if (!(p instanceof Element)) continue;
            return (Element)p;
        }
        return null;
    }

    public Element findChildElement(Node elem, String nodeName) {
        if (elem == null) {
            return null;
        }
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        for (int i = 0; i < n; ++i) {
            Element el;
            String nName;
            Node node = nl.item(i);
            if (!(node instanceof Element) || this.txtUtil.isEmpty(nName = (el = (Element)node).getNodeName())) continue;
            if (nName.equals(nodeName)) {
                return el;
            }
            Element cel = this.findChildElement(el, nodeName);
            if (cel == null) continue;
            return cel;
        }
        return null;
    }

    public Node findNode(Document doc, String xpath) throws XPathExpressionException {
        XPath path = XPathFactory.newInstance().newXPath();
        return (Node)path.evaluate(xpath, doc, XPathConstants.NODE);
    }

    public Element findFirstChildElement(Node elem) {
        if (elem == null) {
            return null;
        }
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public Element findLastChildElement(Node elem) {
        if (elem == null) {
            return null;
        }
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        Element ret = null;
        for (int i = 0; i < n; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            ret = (Element)node;
        }
        return ret;
    }

    public static String toString(Node node) throws TransformerException {
        if (node == null) {
            return "";
        }
        DOMSource source = new DOMSource(node);
        StringWriter swriter = new StringWriter();
        StreamResult result = new StreamResult(swriter);
        TransformerFactory tff = TransformerFactory.newInstance();
        Transformer tf = tff.newTransformer();
        tf.transform(source, result);
        return swriter.toString();
    }
}

