/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.common.log.NyxSimpleFormatter;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class TextUtility {
    private static final BASE64Decoder base64Decoder = new BASE64Decoder();
    private static final BASE64Encoder base64Encoder = new BASE64Encoder();
    private static SecureRandom RANDAM;

    public boolean checkHalfKana(String value) {
        if (value == null) {
            return false;
        }
        Pattern p = Pattern.compile("[\uff61-\uff9f]", 66);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public boolean checkHiragana(String value) {
        if (value == null) {
            return false;
        }
        Pattern p = Pattern.compile("[\u3041-\u3094]");
        Matcher m = p.matcher(value);
        return m.find();
    }

    public boolean isOnlyHiragana(String value) {
        if (value == null) {
            return false;
        }
        Pattern p = Pattern.compile("[^\u3041-\u3094]");
        Matcher m = p.matcher(value);
        return !m.find();
    }

    public boolean isPostalCode(String value) {
        if (value == null) {
            return false;
        }
        Pattern p = Pattern.compile("[0-9]{3}-[0-9]{4}", 66);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public boolean checkHtmlTag(String value) {
        if (value == null) {
            return false;
        }
        Pattern p = Pattern.compile("<[^>]+>", 66);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public boolean isNumber(String value) {
        if (this.isEmpty(value)) {
            return true;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isUnsignedNumber(String value) {
        if (this.isEmpty(value)) {
            return true;
        }
        try {
            double d = Double.parseDouble(value);
            return d >= 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isEquals(String value1, String value2) {
        boolean emp = this.isEmpty(value1);
        if (!emp) {
            return value1.equals(value2);
        }
        emp = this.isEmpty(value2);
        if (!emp) {
            return value2.equals(value1);
        }
        return true;
    }

    public String nvl(String value) {
        return this.nvl(value, "");
    }

    public String nvl(String value, String replace) {
        boolean b = value == null || "".equals(value);
        return b ? replace : value;
    }

    public String getEmpty(Object isVal, String replace) {
        return isVal != null ? replace : "";
    }

    public String replace(String value, String regex, String replacement) {
        if (this.isEmpty(value)) {
            return "";
        }
        return value.replaceAll(regex, replacement);
    }

    public String urlEncode(String value, String encode) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, encode);
    }

    public String urlEncode(String value) throws UnsupportedEncodingException {
        return this.urlEncode(value, "8859_1");
    }

    public String base64Encode(byte[] value) {
        return base64Encoder.encodeBuffer(value);
    }

    public void base64Encode(InputStream value, OutputStream out) throws IOException {
        base64Encoder.encodeBuffer(value, out);
    }

    public byte[] base64Decode(String value) throws IOException {
        return base64Decoder.decodeBuffer(value);
    }

    public String encodeBR(String value) {
        value = this.replace(value, "\r", "");
        value = this.replace(value, "\n", "<br/>");
        return value;
    }

    public String encodeEntityRef(String value) {
        value = this.replace(value, "<", "&lt;");
        value = this.replace(value, ">", "&gt;");
        value = this.replace(value, "&", "&amp;");
        value = this.replace(value, "\"", "&quot;");
        value = this.replace(value, " ", "&nbsp;");
        return value;
    }

    public void base64Decode(InputStream value, OutputStream out) throws IOException {
        base64Decoder.decodeBuffer(value, out);
    }

    public String outThrowable(Throwable th) {
        StringBuffer sb = new StringBuffer();
        NyxSimpleFormatter.outThrowable(sb, th);
        return sb.toString();
    }

    public String random() {
        byte[] s = RANDAM.generateSeed(8);
        byte[] b = new byte[8];
        RANDAM.setSeed(s);
        RANDAM.nextBytes(b);
        return "_" + this.base64Encode(b).replaceAll("\\p{Punct}", "A");
    }

    public String getPart(String regex, CharSequence input, int group) {
        Pattern pt = Pattern.compile(regex);
        Matcher m = pt.matcher(input);
        if (!m.find()) {
            return null;
        }
        return m.group(group);
    }

    static {
        try {
            RANDAM = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

