/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.util.CalendarUtility;
import jp.nyx.common.util.NumberUtility;
import jp.nyx.common.util.TextUtility;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class WebUtility {
    public static final long DEFAULT_MAX_FILE_UPLOAD_SIZE = 0x200000L;
    public final TextUtility textUtil = new TextUtility();
    public final NumberUtility numUtil = new NumberUtility();
    public final CalendarUtility calUtil = new CalendarUtility();
    private static String uploadEncoding = "Windows-31J";

    public void sendRedirect(ServletContext context, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        RequestDispatcher d = context.getRequestDispatcher(path);
        d.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void sendAuthenticate(HttpServletRequest request, HttpServletResponse response, URL failer_site) throws IOException {
        request.setAttribute("error_msg", (Object)"\u5165\u529b\u3055\u308c\u305fID\u53c8\u306fPW\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        response.addHeader("WWW-Authenticate", "Basic realm=\"Please input your user account or OpenID.\"");
        this.redirectError(request, response, 401, "Authoritation failed. This is portal error.", failer_site);
    }

    public void redirectError(HttpServletRequest request, HttpServletResponse response, int code, String msg, URL failer_site) throws IOException {
        response.setStatus(code);
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>SecureSwitch - Error report</title><style>");
        out.println("<!--");
        out.println("H1{color:white;background-color:#525D76;font-size:22px;}");
        out.println("H2{font-size:16px;}");
        out.println("H3{color:white;background-color:#525D76;font-size:14px;}");
        out.println("BODY{color:#525D76;background-color:white;}");
        out.println("--></style>");
        if (failer_site != null) {
            out.println("<meta http-equiv=\"refresh\" content=\"0;URL=" + failer_site + "\">");
        }
        out.println("</head><body>");
        out.println("<h1>HTTP Status " + code + "</h1><br/>");
        out.println("<h2>" + msg + "</h2>");
        out.println("<hr size=\"1\" noshade=\"noshade\">");
        out.println("<h3>SecureSwitch, Powered by Nyx kernel.(Host:" + request.getServerName() + ")</h3>");
        out.println("</body></html>");
    }

    public void pipe(InputStream in, OutputStream out) throws IOException {
        int bufsize = 65536;
        BufferedInputStream bin = new BufferedInputStream(in, bufsize);
        BufferedOutputStream bout = new BufferedOutputStream(out, bufsize);
        byte[] b = new byte[bufsize];
        int n = -1;
        while ((n = bin.read(b, 0, bufsize)) > 0) {
            bout.write(b, 0, n);
        }
        bout.flush();
    }

    public URL createRequestURL(String requestUrl, String requestUri, String queryString) throws IOException {
        URL reqUrl = new URL(requestUrl);
        String pathStr = requestUri;
        StringBuffer sb = new StringBuffer();
        String[] sp = pathStr.split("/");
        for (int i = 0; i < sp.length; ++i) {
            if (this.textUtil.isEmpty(sp[i])) continue;
            sb.append("/");
            sb.append(sp[i]);
        }
        if (pathStr.lastIndexOf(47) == pathStr.length() - 1) {
            sb.append("/");
        }
        String path = sb.toString();
        if (!this.textUtil.isEmpty(queryString)) {
            path = path + '?' + queryString;
        }
        return new URL(reqUrl.getProtocol(), reqUrl.getHost(), reqUrl.getPort(), path);
    }

    public URL createRequestURL(HttpServletRequest request) throws IOException {
        return this.createRequestURL(request.getRequestURL().toString(), request.getRequestURI(), request.getQueryString());
    }

    private String parseAuth(HttpServletRequest request) throws IOException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        String auth = authHeader.substring(authHeader.indexOf("Basic ") + "Basic ".length());
        return new String(this.textUtil.base64Decode(auth));
    }

    public String parseRequestUser(HttpServletRequest request) throws IOException {
        String auth = this.parseAuth(request);
        if (this.textUtil.isEmpty(auth)) {
            return null;
        }
        int i = auth.indexOf(58);
        if (i <= 0) {
            return "";
        }
        return auth.substring(0, i);
    }

    public String parseRequestPasswd(HttpServletRequest request) throws IOException, NoSuchAlgorithmException {
        String auth = this.parseAuth(request);
        if (this.textUtil.isEmpty(auth)) {
            return null;
        }
        return auth.substring(auth.indexOf(58) + 1);
    }

    public Map<String, Object> uploadFile(HttpServletRequest request) {
        return this.uploadFile(request, 0x200000L);
    }

    public Map<String, Object> uploadFile(HttpServletRequest request, long maxUploadSize) {
        try {
            ServletRequestContext rcontext = new ServletRequestContext(request);
            if (!FileUploadBase.isMultipartContent((RequestContext)rcontext)) {
                TreeMap<String, Object> ret = new TreeMap<String, Object>();
                Enumeration keys = request.getParameterNames();
                while (keys.hasMoreElements()) {
                    String k = (String)keys.nextElement();
                    String[] vs = request.getParameterValues(k);
                    if (vs != null) {
                        if (k.endsWith("[]") || k.endsWith("[]") && vs.length > 1) {
                            ret.put(k, vs);
                            continue;
                        }
                        ret.put(k, vs[0]);
                        continue;
                    }
                    ret.put(k, request.getParameter(k));
                }
                return ret;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(0x200000);
            factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(maxUploadSize);
            upload.setHeaderEncoding(uploadEncoding);
            Iterator it = upload.parseRequest((RequestContext)rcontext).iterator();
            TreeMap<String, Object> ret = new TreeMap<String, Object>();
            while (it.hasNext()) {
                FileItem fi = (FileItem)it.next();
                if (!fi.isFormField()) {
                    ret.put(fi.getFieldName(), fi);
                    continue;
                }
                if (!fi.isFormField()) continue;
                ret.put(fi.getFieldName(), fi.getString("UTF-8"));
            }
            return ret;
        }
        catch (Exception e) {
            NyxException.logger.warn((Object)"\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u53d7\u4fe1\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            return new TreeMap<String, Object>();
        }
    }

    public void uploadFilePipe(FileItem source, OutputStream target) {
        try {
            BufferedInputStream bin = new BufferedInputStream(source.getInputStream());
            byte[] b = new byte[1024];
            int n = 0;
            while ((n = bin.read(b, 0, b.length)) > 0) {
                target.write(b, 0, n);
            }
            target.flush();
        }
        catch (Exception e) {
            NyxException.logger.warn((Object)"\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u66f8\u51fa\u3057\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
        }
    }

    public void sendmail(String smtpIp, String smtpPort, String from, String[] to, String subject, String body) throws AddressException, MessagingException, UnsupportedEncodingException {
        this.sendmail(smtpIp, smtpPort, from, to, null, null, subject, body);
    }

    public void sendmail(String smtpIp, String smtpPort, String from, String[] to, String[] cc, String subject, String body) throws AddressException, MessagingException, UnsupportedEncodingException {
        this.sendmail(smtpIp, smtpPort, from, to, cc, null, subject, body);
    }

    public void sendmail(String smtpIp, String smtpPort, String from, String[] to, String[] cc, String[] bcc, String subject, String body) throws AddressException, MessagingException, UnsupportedEncodingException {
        InternetAddress toAddr;
        int i;
        Properties conf = new Properties();
        conf.put("mail.host", smtpIp);
        conf.put("mail.smtp.host", smtpIp);
        conf.put("mail.smtp.port", smtpPort);
        conf.put("mail.smtp.conectiontimeout", "60000");
        conf.put("mail.smtp.timeout", "180000");
        Session session = Session.getDefaultInstance((Properties)conf, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(from, "", "iso-2022-jp"));
        for (i = 0; to != null && i < to.length; ++i) {
            toAddr = new InternetAddress(to[i]);
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)toAddr);
        }
        for (i = 0; cc != null && i < cc.length; ++i) {
            toAddr = new InternetAddress(cc[i]);
            mimeMessage.addRecipient(Message.RecipientType.CC, (Address)toAddr);
        }
        for (i = 0; bcc != null && i < bcc.length; ++i) {
            toAddr = new InternetAddress(bcc[i]);
            mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)toAddr);
        }
        mimeMessage.setSubject(subject, "ISO-2022-JP");
        mimeMessage.setHeader("Date", this.calUtil.formatCalendar(this.calUtil.getCalendar(), "EEE, d MMM yyyy H:m:s Z", Locale.ENGLISH));
        mimeMessage.setHeader("X-Mailer", "JavaMailer");
        mimeMessage.setHeader("Content-Type", "text/plain; charset=\"ISO-2022-JP\"");
        mimeMessage.setText(body, "ISO-2022-JP");
        Transport.send((Message)mimeMessage);
    }

    public String createQueryPath(URL site) {
        StringBuffer sb = new StringBuffer(site.getPath());
        String query = site.getQuery();
        if (!this.textUtil.isEmpty(query)) {
            sb.append("?");
            sb.append(query);
        }
        return sb.toString();
    }
}

