/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util.spec;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Set;
import jp.nyx.NyxException;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.jce.PKCS10CertificationRequest;

public class Csr {
    private PKCS10CertificationRequest p10;
    private CertificationRequestInfo info;
    private HashMap<String, String> dnMap = new HashMap();

    public Csr(PKCS10CertificationRequest p10) {
        this.p10 = p10;
        this.info = p10.getCertificationRequestInfo();
        String[] ns = this.getSubject().split(",");
        for (int i = 0; i < ns.length; ++i) {
            String[] np = ns[i].split("=", 2);
            this.dnMap.put(np[0], np[1]);
        }
    }

    public String getSubject() {
        return this.info.getSubject().toString();
    }

    public String getSubjectPart(String key) {
        return this.dnMap.get(key);
    }

    public Set<String> getSubjectPartKeys() {
        return this.dnMap.keySet();
    }

    public PublicKey getPublicKey() throws NyxException {
        try {
            return this.p10.getPublicKey();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public byte[] getEncoded() {
        return this.p10.getEncoded();
    }
}

