/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util.spec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import jp.nyx.NyxException;
import jp.nyx.common.util.spec.SignedObject;

public class SimpleSignedObject
extends SignedObject {
    protected Signature sign;
    public java.security.SignedObject signObj = null;
    protected Folder folder;

    @Override
    protected void init(Serializable source, PrivateKey signingKey, X509Certificate x509Certificate, Signature sign) throws NyxException {
        if (sign == null) {
            throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:sign");
        }
        if (source != null && signingKey == null) {
            throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:source=" + source + " / signingKey=" + signingKey);
        }
        if (source == null && signingKey != null) {
            throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:source=" + source + " / signingKey=" + signingKey);
        }
        if (x509Certificate == null) {
            throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:x509Certificate");
        }
        this.sign = sign;
        this.folder = new Folder();
        this.folder.x509Certificate = x509Certificate;
        this.folder.source = source;
        try {
            this.signObj = new java.security.SignedObject(this.folder, signingKey, sign);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public Serializable getSource() throws NyxException {
        try {
            if (this.signObj == null) {
                throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:this.signObj");
            }
            Folder f = (Folder)this.signObj.getObject();
            return f.source;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public boolean verify() throws NyxException {
        try {
            if (this.folder.x509Certificate == null) {
                throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u306bnull\u53c8\u306f\u7a7a\u5024\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002:this.folder.x509Certificate");
            }
            this.folder.x509Certificate.verify(this.folder.x509Certificate.getPublicKey());
            boolean ret = this.signObj.verify(this.folder.x509Certificate.getPublicKey(), this.sign);
            if (!ret) {
                NyxException.logger.warn((Object)"\u7f72\u540d\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
            NyxException.logger.info((Object)"\u7f72\u540d\u306f\u6b63\u5e38\u3067\u3059\u3002");
            return true;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public void serializ(OutputStream out) throws NyxException {
        try {
            BufferedOutputStream bout = new BufferedOutputStream(out);
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.signObj);
            oout.flush();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public void parse(InputStream in) throws NyxException {
        try {
            BufferedInputStream bin = new BufferedInputStream(in);
            ObjectInputStream oin = new ObjectInputStream(bin);
            this.signObj = (java.security.SignedObject)oin.readObject();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public X509Certificate getX509Certificate() throws NyxException {
        return this.folder.x509Certificate;
    }

    protected class Folder
    implements Serializable {
        private static final long serialVersionUID = -3381748863455892615L;
        public Serializable source = null;
        protected X509Certificate x509Certificate = null;

        protected Folder() {
        }
    }
}

