/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.sql.rowset.serial.SerialBlob;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.util.CalendarUtility;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.common.util.TextUtility;
import jp.nyx.pkg.ca.db.Cert;
import jp.nyx.pkg.ca.db.Crl;
import jp.nyx.pkg.ca.db.CrlEntry;
import jp.nyx.pkg.ca.db.NewCert;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class CaDao
extends JdbcDaoSupport {
    private static TextUtility txtUtil = new TextUtility();
    private SimpleJdbcTemplate simpleTemplate;
    private NamedParameterJdbcTemplate namedTemplate;
    private CalendarUtility calUtil = new CalendarUtility();
    private ParameterizedRowMapper<Cert> certMapper;
    private ParameterizedRowMapper<NewCert> newCertMapper;
    private ParameterizedRowMapper<Crl> crlMapper;
    private ParameterizedRowMapper<CrlEntry> crlEntryMapper;
    private PkiUtility util = new PkiUtility();
    private NyxManager nyxManager;

    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.simpleTemplate = new SimpleJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.certMapper = new ParameterizedRowMapper<Cert>(){

            public Cert mapRow(ResultSet rs, int rowNum) throws SQLException {
                Cert ret = new Cert();
                ret.setSerialno(rs.getString("serialno"));
                ret.setIssuerName(new X500Principal(rs.getString("issuer_name")));
                ret.setSubjectName(new X500Principal(rs.getString("subject_name")));
                ret.setAlias(rs.getString("alias"));
                ret.setVersion(rs.getString("version"));
                ret.setSignalgName(rs.getString("signalg_name"));
                ret.setHashvalue(rs.getString("hashvalue"));
                ret.setVerifyStartdate(rs.getTimestamp("verify_startdate"));
                ret.setVerifyEnddate(rs.getTimestamp("verify_enddate"));
                ret.setCertType(rs.getString("cert_type"));
                ret.setCertLength(rs.getInt("cert_length"));
                ret.setKeyEntry(rs.getString("key_entry"));
                ret.setLastUpdate(rs.getTimestamp("last_update"));
                Blob cert = rs.getBlob("cert");
                Blob privatekey = rs.getBlob("privatekey");
                try {
                    InputStreamReader in = new InputStreamReader(cert.getBinaryStream());
                    ret.setCertObj(CaDao.this.util.loadX509Certificate((Reader)in));
                    in.close();
                    if (privatekey != null) {
                        in = new InputStreamReader(privatekey.getBinaryStream());
                        ret.setPrivatekeyObj(CaDao.this.util.loadPrivateKey((Reader)in));
                        in.close();
                    }
                }
                catch (Exception e) {
                    SQLException se = new SQLException(e.getMessage());
                    se.initCause(e);
                    throw se;
                }
                return ret;
            }
        };
        this.newCertMapper = new ParameterizedRowMapper<NewCert>(){

            public NewCert mapRow(ResultSet rs, int rowNum) throws SQLException {
                NewCert ret = new NewCert();
                ret.setSerialno(rs.getString("serialno"));
                ret.setIssuerName(new X500Principal(rs.getString("issuer_name")));
                ret.setSubjectName(new X500Principal(rs.getString("subject_name")));
                ret.setAlias(rs.getString("alias"));
                ret.setVersion(rs.getString("version"));
                ret.setSignalgName(rs.getString("signalg_name"));
                ret.setHashvalue(rs.getString("hashvalue"));
                ret.setVerifyStartdate(rs.getTimestamp("verify_startdate"));
                ret.setVerifyEnddate(rs.getTimestamp("verify_enddate"));
                ret.setCertType(rs.getString("cert_type"));
                ret.setCertLength(rs.getInt("cert_length"));
                ret.setKeyEntry(rs.getString("key_entry"));
                ret.setLastUpdate(rs.getTimestamp("last_update"));
                Blob cert = rs.getBlob("cert");
                Blob privatekey = rs.getBlob("privatekey");
                try {
                    InputStreamReader in = new InputStreamReader(cert.getBinaryStream());
                    ret.setCertObj(CaDao.this.util.loadX509Certificate((Reader)in));
                    in.close();
                    if (privatekey != null) {
                        in = new InputStreamReader(privatekey.getBinaryStream());
                        ret.setPrivatekeyObj(CaDao.this.util.loadPrivateKey((Reader)in));
                        in.close();
                    }
                }
                catch (Exception e) {
                    SQLException se = new SQLException(e.getMessage());
                    se.initCause(e);
                    throw se;
                }
                return ret;
            }
        };
        this.crlMapper = new ParameterizedRowMapper<Crl>(){

            public Crl mapRow(ResultSet rs, int rowNum) throws SQLException {
                Crl ret = new Crl();
                ret.setCrlno(rs.getString("crlno"));
                ret.setIssuerName(rs.getString("issuer_name"));
                ret.setVersion(rs.getString("version"));
                ret.setAlias(rs.getString("alias"));
                ret.setSignalgName(rs.getString("signalg_name"));
                ret.setHashvalue(rs.getString("hashvalue"));
                ret.setVerifyStartdate(rs.getTimestamp("verify_startdate"));
                ret.setNextUpdate(rs.getTimestamp("next_update"));
                ret.setCrlType(rs.getString("crl_type"));
                ret.setCrlLength(rs.getInt("crl_length"));
                ret.setLastUpdate(rs.getTimestamp("last_update"));
                Blob crl = rs.getBlob("crl");
                try {
                    BufferedInputStream in = new BufferedInputStream(crl.getBinaryStream());
                    ret.setCrlObj(CaDao.this.util.loadX509CRL((InputStream)in));
                    in.close();
                }
                catch (Exception e) {
                    SQLException se = new SQLException(e.getMessage());
                    se.initCause(e);
                    throw se;
                }
                return ret;
            }
        };
        this.crlEntryMapper = new ParameterizedRowMapper<CrlEntry>(){

            public CrlEntry mapRow(ResultSet rs, int rowNum) throws SQLException {
                CrlEntry ret = new CrlEntry();
                ret.setCrlno(rs.getString("crlno"));
                ret.setIssuerName(rs.getString("issuer_name"));
                ret.setSerialno(rs.getString("serialno"));
                ret.setReasonDate(rs.getTimestamp("reason_date"));
                ret.setReason(rs.getString("reason"));
                ret.setLastUpdate(rs.getTimestamp("last_update"));
                return ret;
            }
        };
    }

    public int update(String sql) throws SQLException {
        if (NyxException.logger.isDebugEnabled()) {
            NyxException.logger.debug((Object)sql);
        }
        return this.simpleTemplate.update(sql, new Object[0]);
    }

    public boolean isInit() {
        try {
            this.simpleTemplate.queryForList("select * from ca_cert where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select * from ca_newcert where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select * from ca_crl where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select * from ca_crl_entory where 1=0", new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInitCa() {
        try {
            int n = this.simpleTemplate.queryForInt("select count(*) from ca_cert where key_entry='t'", new Object[0]);
            return n > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long nextSequence(String sequenceName) throws SQLException {
        if (this.nyxManager.isPostgreSQL()) {
            return this.simpleTemplate.queryForLong("select nextval(?)", new Object[]{sequenceName});
        }
        this.update("update " + sequenceName + " set seq=seq+1");
        return this.simpleTemplate.queryForLong("select max(seq) from " + sequenceName, new Object[0]);
    }

    public long currSequence(String sequenceName) throws SQLException {
        if (this.nyxManager.isPostgreSQL()) {
            return this.simpleTemplate.queryForLong("select currval(?)", new Object[]{sequenceName});
        }
        return this.simpleTemplate.queryForLong("select max(seq) from " + sequenceName, new Object[0]);
    }

    private String createWhere(int offset, int limit, ConditionList conditions, ArrayList<Object> values) throws SQLException {
        StringBuffer where = new StringBuffer();
        if (conditions != null) {
            for (Condition c : conditions) {
                String k;
                if (c == null || txtUtil.isEmpty(k = c.getColoumName())) continue;
                if (where.length() <= 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(k);
                where.append(" ");
                where.append(c.getOperate());
                where.append(" ?");
                values.add(c.getColoumValue());
            }
        }
        if (this.nyxManager.isPostgreSQL()) {
            values.add(offset);
            values.add(limit);
        }
        return where.toString();
    }

    public List<Cert> loadCert(int offset, int limit, ConditionList conditions) throws SQLException {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = this.createWhere(offset, limit, conditions, cond);
        if (this.nyxManager.isPostgreSQL()) {
            return this.simpleTemplate.query("select * from ca_cert" + where.toString() + " order by issuer_name, subject_name, serialno offset ? limit ?", this.certMapper, cond.toArray());
        }
        return this.simpleTemplate.query("select * from ca_cert" + where.toString() + " order by issuer_name, subject_name, serialno", this.certMapper, cond.toArray());
    }

    public void saveCert(Cert cert) throws NyxException, NoSuchAlgorithmException, SQLException {
        int r;
        X509Certificate c = cert.getCertObj();
        if (c == null) {
            throw new NullPointerException("cert.getCertObj() is null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter wr = new OutputStreamWriter(out);
        this.util.saveX509Certificate(c, (Writer)wr);
        byte[] b = out.toByteArray();
        if (txtUtil.isEmpty(cert.getAlias())) {
            cert.setAlias(this.util.getNameValue(c.getIssuerX500Principal(), "CN"));
        }
        cert.setCert(new SerialBlob(b));
        cert.setCertLength(out.size());
        cert.setCertType(c.getType());
        MessageDigest digest = MessageDigest.getInstance(this.util.getMsgDigestAlg());
        digest.update(b);
        cert.setHashvalue(this.util.base64encode(digest.digest()));
        cert.setIssuerName(c.getIssuerX500Principal());
        Calendar cal = this.calUtil.getCalendar();
        cert.setLastUpdate(new Timestamp(cal.getTimeInMillis()));
        cert.setSerialno(c.getSerialNumber().toString());
        cert.setSignalgName(c.getSigAlgName());
        cert.setSubjectName(c.getSubjectX500Principal());
        cert.setVerifyStartdate(new Timestamp(c.getNotBefore().getTime()));
        cert.setVerifyEnddate(new Timestamp(c.getNotAfter().getTime()));
        cert.setVersion(String.valueOf(c.getVersion()));
        PrivateKey p = cert.getPrivatekeyObj();
        if (p != null) {
            out = new ByteArrayOutputStream();
            wr = new OutputStreamWriter(out);
            this.util.savePrivateKey(p, (Writer)wr);
            cert.setPrivatekey(new SerialBlob(out.toByteArray()));
            cert.setKeyEntry("t");
        }
        if ((r = this.namedTemplate.update("update ca_cert set subject_name=:subjectNameString, version=:version, alias=:alias, signalg_name=:signalgName, hashvalue=:hashvalue, verify_startdate=:verifyStartdate, verify_enddate=:verifyEnddate, cert_type=:certType" + txtUtil.getEmpty((Object)cert.getCert(), ", cert=:cert") + txtUtil.getEmpty((Object)cert.getPrivatekey(), ", privatekey=:privatekey") + ", key_entry=:keyEntry, last_update=:lastUpdate where serialno=:serialno and issuer_name=:issuerNameString", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)cert))) > 0) {
            return;
        }
        this.namedTemplate.update("insert into ca_cert(serialno,issuer_name,subject_name,alias,version,signalg_name,hashvalue,verify_startdate,verify_enddate,cert_type,cert_length" + txtUtil.getEmpty((Object)cert.getCert(), ",cert") + txtUtil.getEmpty((Object)cert.getPrivatekey(), ",privatekey") + ",key_entry,last_update) values(:serialno,:issuerNameString,:subjectNameString,:alias,:version,:signalgName,:hashvalue,:verifyStartdate,:verifyEnddate,:certType,:certLength" + txtUtil.getEmpty((Object)cert.getCert(), ",:cert") + txtUtil.getEmpty((Object)cert.getPrivatekey(), ",:privatekey") + ",:keyEntry,:lastUpdate)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)cert));
    }

    public List<NewCert> loadNewCert(int offset, int limit, ConditionList conditions) throws SQLException {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = this.createWhere(offset, limit, conditions, cond);
        if (this.nyxManager.isPostgreSQL()) {
            return this.simpleTemplate.query("select * from ca_newcert" + where.toString() + " order by issuer_name, subject_name, serialno offset ? limit ?", this.newCertMapper, cond.toArray());
        }
        return this.simpleTemplate.query("select * from ca_newcert" + where.toString() + " order by issuer_name, subject_name, serialno", this.newCertMapper, cond.toArray());
    }

    public void saveNewCert(NewCert newcert) throws NyxException, NoSuchAlgorithmException, SQLException {
        int r;
        X509Certificate c = newcert.getCertObj();
        if (c == null) {
            throw new NullPointerException("newcert.getCertObj() is null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter wr = new OutputStreamWriter(out);
        this.util.saveX509Certificate(c, (Writer)wr);
        byte[] b = out.toByteArray();
        if (txtUtil.isEmpty(newcert.getAlias())) {
            newcert.setAlias(this.util.getNameValue(c.getIssuerX500Principal(), "CN"));
        }
        newcert.setCert(new SerialBlob(b));
        newcert.setCertLength(out.size());
        newcert.setCertType(c.getType());
        MessageDigest digest = MessageDigest.getInstance(this.util.getMsgDigestAlg());
        digest.update(b);
        newcert.setHashvalue(this.util.base64encode(digest.digest()));
        newcert.setIssuerName(c.getIssuerX500Principal());
        Calendar cal = this.calUtil.getCalendar();
        newcert.setLastUpdate(new Timestamp(cal.getTimeInMillis()));
        newcert.setSerialno(c.getSerialNumber().toString());
        newcert.setSignalgName(c.getSigAlgName());
        newcert.setSubjectName(c.getSubjectX500Principal());
        newcert.setVerifyStartdate(new Timestamp(c.getNotBefore().getTime()));
        newcert.setVerifyEnddate(new Timestamp(c.getNotAfter().getTime()));
        newcert.setVersion(String.valueOf(c.getVersion()));
        PrivateKey p = newcert.getPrivatekeyObj();
        if (p != null) {
            out = new ByteArrayOutputStream();
            wr = new OutputStreamWriter(out);
            this.util.savePrivateKey(p, (Writer)wr);
            newcert.setPrivatekey(new SerialBlob(out.toByteArray()));
            newcert.setKeyEntry("t");
        }
        if ((r = this.namedTemplate.update("update ca_newcert set subject_name=:subjectNameString, alias=:alias, version=:version, signalg_name=:signalgName, hashvalue=:hashvalue, verify_startdate=:verifyStartdate, verify_enddate=:verifyEnddate, cert_type=:certType, cert=:cert, privatekey=:privatekey, key_entry=:keyEntry, last_update=:lastUpdate where serialno=:serialno and issuer_name=:issuerNameString", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)newcert))) > 0) {
            return;
        }
        this.namedTemplate.update("insert into ca_newcert(serialno,issuer_name,subject_name,alias,version,signalg_name,hashvalue,verify_startdate,verify_enddate,cert_type,cert_length,cert,privatekey,key_entry,last_update) values(:serialno,:issuerNameString,:subjectNameString,:alias,:version,:signalgName,:hashvalue,:verifyStartdate,:verifyEnddate,:certType,:certLength,:cert,:privatekey,:keyEntry,:lastUpdate)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)newcert));
    }

    public List<Crl> loadCrl(int offset, int limit, ConditionList conditions) throws SQLException {
        ArrayList<Object> cond = new ArrayList<Object>();
        String where = this.createWhere(offset, limit, conditions, cond);
        List ret = this.nyxManager.isPostgreSQL() ? this.simpleTemplate.query("select * from ca_crl" + where.toString() + " order by crlno, issuer_name, last_update offset ? limit ?", this.crlMapper, cond.toArray()) : this.simpleTemplate.query("select * from ca_crl" + where.toString() + " order by crlno, issuer_name, last_update", this.crlMapper, cond.toArray());
        int n = ret.size();
        for (int i = 0; i < n; ++i) {
            Crl c = (Crl)ret.get(i);
            c.setCrlEntry(this.loadCrlEntry(c));
        }
        return ret;
    }

    public void saveCrl(Crl crl) throws NyxException, NoSuchAlgorithmException, CRLException, SQLException {
        X509CRL c = crl.getCrlObj();
        if (c == null) {
            throw new NullPointerException("crl.getCrlObj() is null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.util.saveX509CRL(c, (OutputStream)out);
        crl.setCrl(new SerialBlob(out.toByteArray()));
        if (txtUtil.isEmpty(crl.getAlias())) {
            crl.setAlias(this.util.getNameValue(c.getIssuerX500Principal(), "CN"));
        }
        crl.setCrlLength(out.size());
        crl.setCrlType(c.getType());
        MessageDigest digest = MessageDigest.getInstance(this.util.getMsgDigestAlg());
        digest.update(c.getEncoded());
        crl.setHashvalue(this.util.base64encode(digest.digest()));
        crl.setIssuerName(c.getIssuerX500Principal().getName("RFC2253"));
        Calendar cal = this.calUtil.getCalendar();
        crl.setLastUpdate(new Timestamp(cal.getTimeInMillis()));
        crl.setSignalgName(c.getSigAlgName());
        crl.setNextUpdate(new Timestamp(c.getNextUpdate().getTime()));
        crl.setVersion("" + c.getVersion());
        int r = this.namedTemplate.update("update ca_crl set alias=:alias, version=:version, signalg_name=:signalgName, hashvalue=:hashvalue, verify_startdate=:verifyStartdate, next_update=:nextUpdate, crl_type=:crlType, crl_length=:crlLength, crl=:crl, last_update=:lastUpdate where crlno=:crlno and issuer_name=:issuerName", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)crl));
        if (r > 0) {
            return;
        }
        this.namedTemplate.update("insert into ca_crl(crlno,issuer_name,alias,version,signalg_name,hashvalue,verify_startdate,next_update,crl_type,crl_length,crl,last_update) values(:crlno,:issuerName,:alias,:version,:signalgName,:hashvalue,:verifyStartdate,nextUpdate,:crlType,:crlLength,:crl,:lastUpdate)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)crl));
        this.namedTemplate.update("delete from ca_crl_entory where serialno=:serialno and issuer_name=:issuerName", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)crl));
        Set<? extends X509CRLEntry> entory = c.getRevokedCertificates();
        if (entory == null) {
            return;
        }
        Iterator<? extends X509CRLEntry> it = entory.iterator();
        while (it.hasNext()) {
            this.insertCrlEntry(crl.getCrlno(), crl.getIssuerName(), it.next());
        }
    }

    private List<CrlEntry> loadCrlEntry(Crl crl) {
        List ret = this.namedTemplate.query("select * from ca_crl_entory where crlno=:crlno and issuer_name=:issuerName order by issuer_name, serialno", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)crl), this.crlEntryMapper);
        return ret;
    }

    private void insertCrlEntry(String crlno, String issuerName, X509CRLEntry crlEntry) throws NyxException, SQLException {
        Timestamp nowDate = new Timestamp(this.calUtil.getCalendar().getTimeInMillis());
        byte[] r = crlEntry.getExtensionValue("2.5.29.21");
        PkiUtility.CRLReasonCode reason = PkiUtility.CRLReasonCode.getCRLReasonCode((int)r[4]);
        this.simpleTemplate.update("insert into ca_crl_entory(crlno,issuer_name,serialno,reason_date,reason,last_update) values(?,?,?,?,?,?)", new Object[]{crlno, issuerName, crlEntry.getSerialNumber().toString(), new Timestamp(crlEntry.getRevocationDate().getTime()), reason != null ? reason.getReason() : null, nowDate});
    }

    public PkiUtility getUtil() {
        return this.util;
    }

    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }
}

