/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.db;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import jp.nyx.common.util.CalendarUtility;

public class CaDefault {
    private static CalendarUtility calUtil = new CalendarUtility();
    private Calendar now = Calendar.getInstance();
    private String serialno;
    private X500Principal issuerName;
    private Timestamp verifyStartdate;
    private Timestamp verifyEnddate;
    private Timestamp lastUpdate;

    public int getUniqueNo() {
        return (this.serialno + this.getIssuerNameString()).hashCode();
    }

    public String getSerialno() {
        return this.serialno;
    }

    public void setSerialno(String serialno) {
        this.serialno = serialno;
    }

    public String getIssuerNameString() {
        return this.issuerName.getName("RFC2253");
    }

    public X500Principal getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(X500Principal issuerName) {
        this.issuerName = issuerName;
    }

    public Timestamp getVerifyEnddate() {
        return this.verifyEnddate;
    }

    public void setVerifyEnddate(Timestamp verifyEnddate) {
        this.verifyEnddate = verifyEnddate;
    }

    public String getVerifyEndDay() {
        if (this.verifyEnddate == null) {
            return null;
        }
        return calUtil.formatCalendar((Date)this.verifyEnddate, "yyyy/MM/dd");
    }

    public String getVerifyEndTime() {
        if (this.verifyEnddate == null) {
            return null;
        }
        return calUtil.formatCalendar((Date)this.verifyEnddate, "HH:mm");
    }

    public Timestamp getVerifyStartdate() {
        if (this.verifyStartdate == null) {
            this.verifyStartdate = new Timestamp(this.now.getTimeInMillis());
        }
        return this.verifyStartdate;
    }

    public void setVerifyStartdate(Timestamp verifyStartdate) {
        if (this.verifyEnddate == null) {
            this.verifyEnddate = new Timestamp(this.now.getTimeInMillis());
        }
        this.verifyStartdate = verifyStartdate;
    }

    public String getVerifyStartDay() {
        if (this.verifyStartdate == null) {
            return null;
        }
        return calUtil.formatCalendar((Date)this.verifyStartdate, "yyyy/MM/dd");
    }

    public String getVerifyStartTime() {
        if (this.verifyStartdate == null) {
            return null;
        }
        return calUtil.formatCalendar((Date)this.verifyStartdate, "HH:mm");
    }

    public Timestamp getLastUpdate() {
        if (this.lastUpdate == null) {
            this.lastUpdate = new Timestamp(this.now.getTimeInMillis());
        }
        return this.lastUpdate;
    }

    public void setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = new Timestamp(lastUpdate.getTimeInMillis());
    }
}

