/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.pkg.ca.db.CaManager;
import jp.nyx.pkg.ca.db.Cert;
import jp.nyx.pkg.ca.db.NewCert;
import jp.nyx.pkg.ca.web.CaController;
import org.apache.commons.fileupload.FileItem;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class NewCertController
extends CaController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, String> status;
        ModelAndView mv = super.handleRequestInternal(request, response);
        WebApplicationContext appCtx = super.getWebApplicationContext();
        CaManager caManager = (CaManager)appCtx.getBean("caManager");
        caManager.init((ApplicationContext)appCtx);
        Map req = this.webUtil.uploadFile(request, 524288L);
        if ("dlcert".equals(req.get("mode"))) {
            status = this.getStatus(mv);
            try {
                ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                String serialno = (String)req.get("serialno");
                String issuer_name = (String)req.get("issuer_name");
                cond.add((Object)new Condition("serialno", (Object)serialno));
                cond.add((Object)new Condition("issuer_name", (Object)issuer_name));
                cond.add((Object)new Condition("key_entry", (Object)"t"));
                List<NewCert> certs = caManager.loadNewCert(0, 100, cond);
                if (certs == null || certs.size() <= 0) {
                    status.put("status", "Failed");
                    status.put("message", "\u8a3c\u660e\u66f8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    return mv;
                }
                NewCert c = certs.get(0);
                StringWriter w = new StringWriter();
                X509Certificate xc = c.getCertObj();
                X500Principal p = xc.getSubjectX500Principal();
                this.pkiUtil.saveX509Certificate(xc, (Writer)w);
                String cn = this.pkiUtil.getNameValue(p, "CN");
                cn = this.webUtil.textUtil.replace(cn, "[ /]", "");
                status.put("status", "Successed");
                Map<String, Object> res = this.getRes(mv);
                res.put("crt", w.getBuffer().toString());
                response.setHeader("Content-disposition", "attachment; filename=" + cn + ".crt");
                response.setContentType("application/octet-stream");
                return mv;
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u8a3c\u660e\u66f8\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u8a3c\u660e\u66f8\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else {
            Map<String, Object> res;
            if ("dlpkey".equals(req.get("mode"))) {
                Map<String, String> status2 = this.getStatus(mv);
                try {
                    ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                    String serialno = (String)req.get("serialno");
                    String issuer_name = (String)req.get("issuer_name");
                    cond.add((Object)new Condition("serialno", (Object)serialno));
                    cond.add((Object)new Condition("issuer_name", (Object)issuer_name));
                    cond.add((Object)new Condition("key_entry", (Object)"t"));
                    List<NewCert> certs = caManager.loadNewCert(0, 100, cond);
                    if (certs == null || certs.size() <= 0) {
                        status2.put("status", "Failed");
                        status2.put("message", "\u79d8\u5bc6\u9375\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    NewCert c = certs.get(0);
                    StringWriter w = new StringWriter();
                    X500Principal p = c.getCertObj().getSubjectX500Principal();
                    this.pkiUtil.savePrivateKey(c.getPrivatekeyObj(), (Writer)w);
                    String cn = this.pkiUtil.getNameValue(p, "CN");
                    cn = this.webUtil.textUtil.replace(cn, "[ /]", "");
                    status2.put("status", "Successed");
                    Map<String, Object> res2 = this.getRes(mv);
                    res2.put("key", w.getBuffer().toString());
                    response.setHeader("Content-disposition", "attachment; filename=" + cn + ".key");
                    response.setContentType("application/octet-stream");
                }
                catch (Exception e) {
                    status2.put("status", "Failed");
                    status2.put("message", "\u79d8\u5bc6\u9375\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    NyxException.logger.error((Object)"\u79d8\u5bc6\u9375\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                }
                return mv;
            }
            if ("add".equals(req.get("mode"))) {
                ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                cond.add((Object)new Condition("key_entry", (Object)"t"));
                List<Cert> certs = caManager.loadCert(0, 100, cond);
                mv.getModel().put("certs", certs);
                return mv;
            }
            if ("adddo".equals(req.get("mode"))) {
                status = this.getStatus(mv);
                res = this.getRes(mv);
                res.put("mode", "adddo");
                try {
                    String cert_type = (String)req.get("cert_type");
                    String issuer_day = (String)req.get("issuer_day");
                    if (this.webUtil.textUtil.isEmpty((String)req.get("CN"))) {
                        status.put("status", "Failed");
                        status.put("message", "\u56fa\u6709\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    if (this.webUtil.textUtil.isEmpty(cert_type)) {
                        status.put("status", "Failed");
                        status.put("message", "\u8a3c\u660e\u66f8\u30bf\u30a4\u30d7\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    if (!this.webUtil.textUtil.isNumber(issuer_day)) {
                        status.put("status", "Failed");
                        status.put("message", "\u6709\u52b9\u65e5\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    Calendar start = this.webUtil.calUtil.getCalendar();
                    Calendar end = this.webUtil.calUtil.cloneCalendar(start);
                    end.add(6, this.webUtil.numUtil.parseInt(issuer_day, 360));
                    PkiUtility.GenCertType type = PkiUtility.GenCertType.CLIENT;
                    type = "server".equals(cert_type) ? PkiUtility.GenCertType.SERVER : type;
                    type = "subca".equals(cert_type) ? PkiUtility.GenCertType.SUBCA : type;
                    Cert issuerCert = null;
                    ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                    List<Cert> certs = caManager.loadCert(0, 100, cond);
                    int n = certs.size();
                    int u = this.webUtil.numUtil.parseInt((String)req.get("issuer_unique_no"));
                    for (int i = 0; i < n; ++i) {
                        Cert c = certs.get(i);
                        if (c.getUniqueNo() != u) continue;
                        issuerCert = c;
                        break;
                    }
                    caManager.saveNewCert((String)req.get("alias"), (String)req.get("C"), (String)req.get("ST"), (String)req.get("L"), (String)req.get("O"), (String)req.get("OU"), (String)req.get("CN"), start, end, type, issuerCert.getCertObj(), issuerCert.getPrivatekeyObj(), this.getNyx(mv));
                    status.put("status", "Successed");
                    status.put("message", "\u8a3c\u660e\u66f8\u306e\u767a\u884c\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                }
                catch (Exception e) {
                    status.put("status", "Failed");
                    status.put("message", "\u8a3c\u660e\u66f8\u306e\u767a\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    NyxException.logger.error((Object)"\u8a3c\u660e\u66f8\u306e\u767a\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                }
            } else {
                if ("import".equals(req.get("mode"))) {
                    return mv;
                }
                if ("importdo".equals(req.get("mode"))) {
                    status = this.getStatus(mv);
                    res = this.getRes(mv);
                    res.put("mode", "importdo");
                    try {
                        NewCert cert = new NewCert();
                        FileItem fiCert = (FileItem)req.get("cert");
                        if (fiCert == null || this.webUtil.textUtil.isEmpty(fiCert.getString())) {
                            status.put("status", "Failed");
                            status.put("message", "\u8a3c\u660e\u66f8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                            return mv;
                        }
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        this.webUtil.uploadFilePipe(fiCert, (OutputStream)bout);
                        X509Certificate c = this.pkiUtil.loadX509Certificate((InputStream)new ByteArrayInputStream(bout.toByteArray()));
                        cert.setCertObj(c);
                        FileItem fiPri = (FileItem)req.get("privatekey");
                        if (fiPri != null && !this.webUtil.textUtil.isEmpty(fiPri.getString())) {
                            ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
                            this.webUtil.uploadFilePipe(fiPri, (OutputStream)bout2);
                            PrivateKey pk = this.pkiUtil.loadPrivateKey((Reader)new InputStreamReader(new ByteArrayInputStream(bout2.toByteArray())), (String)req.get("keypass"));
                            if (pk == null) {
                                status.put("status", "Failed");
                                status.put("message", "\u79d8\u5bc6\u9375\u4fdd\u8b77\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                            }
                            cert.setPrivatekeyObj(pk);
                            cert.setKeyEntry("t");
                        }
                        if (!"Failed".equals(status.get("status"))) {
                            caManager.saveNewCert(cert);
                            status.put("status", "Successed");
                            status.put("message", "\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                        }
                    }
                    catch (Exception e) {
                        status.put("status", "Failed");
                        status.put("message", "\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        NyxException.logger.error((Object)"\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                    }
                }
            }
        }
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        List<NewCert> certs = caManager.loadNewCert(0, 100, cond);
        mv.getModel().put("certs", certs);
        return mv;
    }
}

