/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.common.taglib.dialog;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.AccessUser;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.pkg.portal.spec.NoticeUtility;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class TicketController
extends SsoController {
    private NoticeUtility noticeUtil = new NoticeUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        Access access = super.getPersonalAccess(request);
        Map<String, String> status = this.getStatus(mv);
        Map<String, Object> res = this.getRes(mv);
        Map<String, Setting> nyx = this.getNyx(mv);
        User self = access.getSelf();
        if (self == null) {
            status.put("status", "Infomation");
            status.put("message", "SSO\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return mv;
        }
        res.put("self", self);
        AccessValidaterUtility.AuthValue authValue = this.getAuthValue(request);
        if (authValue == null || !authValue.isValidTicket()) {
            status.put("status", "Failed");
            status.put("message", "\u3053\u306e\u30b5\u30a4\u30c8\u306f\u30c1\u30b1\u30c3\u30c8\u767a\u884c\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return mv;
        }
        if ("revoke".equals(request.getParameter("mode"))) {
            List<User> users = this.loadTicket(mv, ssoManager, access, self);
            if (users.size() <= 0) {
                status.put("status", "Failed");
                status.put("message", "\u30c1\u30b1\u30c3\u30c8\u306f\u767a\u884c\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return mv;
            }
            User user = users.get(0);
            this.noticeUtil.setNyx(nyx);
            this.noticeUtil.setSsoManager(ssoManager);
            StringBuilder message = new StringBuilder();
            message.append("[ \u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u5931\u52b9\u306e\u304a\u77e5\u3089\u305b ]");
            message.append("\n\u4ee5\u4e0b\u306e\u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u3092\u5931\u52b9\u3057\u307e\u3057\u305f\u306e\u3067\u304a\u77e5\u3089\u305b\u81f4\u3057\u307e\u3059\u3002\n---");
            message.append("\n\u767a\u884cID\uff1a");
            message.append(user.getUserId());
            message.append("\n\u767a\u884cURL\uff1a");
            message.append(user.getModificationValue());
            message.append("\n\u767a\u884c\u8005\uff1a");
            message.append(ssoManager.loadUser(user.getModificationId()).getUserName());
            message.append("\n\u5229\u7528\u958b\u59cb\u65e5\uff1a");
            message.append(user.getVerifyStartDay());
            message.append("\n\u5229\u7528\u7d42\u4e86\u65e5\uff1a");
            message.append(user.getVerifyEndDay());
            Ext ext = (Ext)user.getExt().get("use_memo");
            if (ext != null) {
                message.append("\n\u30e1\u30e2\uff1a");
                message.append(ext.getFieldValue());
            }
            message.append("\n---\n\u4ee5\u4e0a");
            ArrayList<String> to = new ArrayList<String>();
            to.add(self.getUserId());
            String adminMain = nyx.get("base_admin_main").getValue();
            String adminSub1 = nyx.get("base_admin_sub1").getValue();
            String adminSub2 = nyx.get("base_admin_sub2").getValue();
            if (!this.webUtil.textUtil.isEmpty(adminMain)) {
                to.add(adminMain);
            }
            if (!this.webUtil.textUtil.isEmpty(adminSub1)) {
                to.add(adminSub1);
            }
            if (!this.webUtil.textUtil.isEmpty(adminSub2)) {
                to.add(adminSub2);
            }
            NoticeUtility noticeUtility = this.noticeUtil;
            synchronized (noticeUtility) {
                this.noticeUtil.sendNotice(mv, status, this.getRemoteUser(mv), null, null, user.getModificationValue(), "\u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u306e\u5931\u52b9\u306e\u304a\u77e5\u3089\u305b", message.toString(), new String[0], to.toArray(new String[0]), false);
                ssoManager.deleteUser(request.getParameter("issue_user_id"), access);
            }
            status.put("status", "Successed");
            status.put("message", "\u30c1\u30b1\u30c3\u30c8\u3092\u5931\u52b9\u3057\u307e\u3057\u305f\u3002");
            return mv;
        }
        if ("issue".equals(request.getParameter("mode"))) {
            try {
                List<User> users = this.loadTicket(mv, ssoManager, access, self);
                if (users.size() > 0) {
                    User u = users.get(0);
                    status.put("status", "Failed");
                    status.put("message", "\u65e2\u306b\u30c1\u30b1\u30c3\u30c8\u306f\u767a\u884c\u3055\u308c\u3066\u3044\u307e\u3059\u3002(" + u.getUserId() + ")");
                }
                User ticket = new User();
                String issue_user_id = request.getParameter("issue_user_id");
                if (this.webUtil.textUtil.isEmpty(issue_user_id = issue_user_id.trim())) {
                    status.put("status", "Failed");
                    status.put("message", "\u767a\u884cID\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    return mv;
                }
                ticket.setUserId(issue_user_id);
                ticket.setUserName(issue_user_id);
                ticket.setModificationId(self.getUserId());
                ticket.setModificationValue(request.getParameter("modification_value"));
                String password = request.getParameter("password");
                String password2 = request.getParameter("password2");
                if (this.webUtil.textUtil.isEmpty(password)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                if (!password.equals(password2)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
                    return mv;
                }
                ticket.setPasswd(DigestUtility.md5((String)password));
                String verify_startdate = request.getParameter("verify_startdate");
                try {
                    Calendar cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                    ticket.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
                    int verify_term = this.webUtil.numUtil.parseInt(request.getParameter("verify_term"), 1);
                    int maxterm = this.webUtil.numUtil.parseInt(nyx.get("kernel_ticketuid_maxterm").getValue(), 1);
                    if (verify_term > maxterm && 1 > verify_term) {
                        status.put("status", "Failed");
                        status.put("message", "\u8a2d\u5b9a\u53ef\u80fd\u306a\u30c1\u30b1\u30c3\u30c8\u306e\u6709\u52b9\u65e5\u6570\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002");
                        return mv;
                    }
                    cal.add(13, verify_term);
                    ticket.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
                }
                catch (Exception e) {
                    status.put("status", "Failed");
                    status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                AccessUser au = new AccessUser();
                au.setVerifyUserId(self.getUserId());
                au.setVerifyUserName(self.getUserName());
                au.setRegistUid(ticket.getModificationId());
                au.setUpdateUid(ticket.getModificationId());
                au.setVerifyStartdate(ticket.getVerifyStartdate());
                au.setVerifyEnddate(ticket.getVerifyEnddate());
                ticket.getAccessUser().add(au);
                Ext ext = new Ext();
                ext.setFieldDisplay("\u30c1\u30b1\u30c3\u30c8\u30e1\u30e2");
                ext.setFieldName("use_memo");
                ext.setFieldType("ticket");
                ext.setFieldModify("readonly");
                ext.setFieldValue(request.getParameter("use_memo"));
                ext.setRegistUid(ticket.getModificationId());
                ext.setUpdateUid(ticket.getModificationId());
                ext.setVerifyStartdate(ticket.getVerifyStartdate());
                ext.setVerifyEnddate(ticket.getVerifyEnddate());
                ticket.getExt().put(ext.getFieldName(), ext);
                ticket.setUnixGname(ticket.getUserId());
                ticket.setRegistUid(ticket.getModificationId());
                ticket.setUpdateUid(ticket.getModificationId());
                ticket.setUserType("ticket");
                try {
                    this.noticeUtil.setNyx(nyx);
                    this.noticeUtil.setSsoManager(ssoManager);
                    StringBuilder message = new StringBuilder();
                    message.append("[ \u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u767a\u884c\u306e\u304a\u77e5\u3089\u305b ]");
                    message.append("\n\u4ee5\u4e0b\u306e\u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u3092\u767a\u884c\u3057\u307e\u3057\u305f\u306e\u3067\u304a\u77e5\u3089\u305b\u81f4\u3057\u307e\u3059\u3002\n---");
                    message.append("\n\u767a\u884cID\uff1a");
                    message.append(ticket.getUserId());
                    message.append("\n\u767a\u884cURL\uff1a");
                    message.append(ticket.getModificationValue());
                    message.append("\n\u767a\u884c\u8005\uff1a");
                    message.append(ssoManager.loadUser(ticket.getModificationId()).getUserName());
                    message.append("\n\u5229\u7528\u958b\u59cb\u65e5\uff1a");
                    message.append(ticket.getVerifyStartDay());
                    message.append("\n\u5229\u7528\u7d42\u4e86\u65e5\uff1a");
                    message.append(ticket.getVerifyEndDay());
                    message.append("\n\u30e1\u30e2\uff1a");
                    message.append(ext.getFieldValue());
                    message.append("\n---\n\u4ee5\u4e0a");
                    ArrayList<String> to = new ArrayList<String>();
                    to.add(self.getUserId());
                    String adminMain = nyx.get("base_admin_main").getValue();
                    String adminSub1 = nyx.get("base_admin_sub1").getValue();
                    String adminSub2 = nyx.get("base_admin_sub2").getValue();
                    if (!this.webUtil.textUtil.isEmpty(adminMain)) {
                        to.add(adminMain);
                    }
                    if (!this.webUtil.textUtil.isEmpty(adminSub1)) {
                        to.add(adminSub1);
                    }
                    if (!this.webUtil.textUtil.isEmpty(adminSub2)) {
                        to.add(adminSub2);
                    }
                    NoticeUtility noticeUtility = this.noticeUtil;
                    synchronized (noticeUtility) {
                        this.noticeUtil.sendNotice(mv, status, this.getRemoteUser(mv), null, null, ticket.getModificationValue(), "\u30a2\u30af\u30bb\u30b9\u30c1\u30b1\u30c3\u30c8\u306e\u767a\u884c\u306e\u304a\u77e5\u3089\u305b", message.toString(), new String[0], to.toArray(new String[0]), false);
                    }
                    ssoManager.saveUser(ticket, access);
                }
                catch (Exception e) {
                    status.put("status", "Failed");
                    status.put("message", "\u30c1\u30b1\u30c3\u30c8\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    NyxException.logger.error((Object)"\u30c1\u30b1\u30c3\u30c8\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                    return mv;
                }
                status.put("status", "Successed");
                status.put("message", "\u30c1\u30b1\u30c3\u30c8\u3092\u767a\u884c\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u30e6\u30fc\u30b6\u30fc\u306e\u4e00\u89a7\u3092\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u30e6\u30fc\u30b6\u30fc\u306e\u4e00\u89a7\u3092\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        try {
            List<User> users = this.loadTicket(mv, ssoManager, access, self);
            if (users.size() > 0) {
                User u = users.get(0);
                res.put("issued", true);
                res.put("issue_user_id", u.getUserId());
                res.put("modification_id", u.getModificationId());
                res.put("modification_value", u.getModificationValue());
                res.put("verifyStartDay", u.getVerifyStartDay());
                res.put("verifyEndDay", u.getVerifyEndDay());
                Ext ext = (Ext)u.getExt().get("use_memo");
                if (ext != null) {
                    res.put("use_memo", ext.getFieldValue());
                }
                return mv;
            }
            String issue_user_id = nyx.get("kernel_ticketuid_prefix").getValue() + this.webUtil.textUtil.random();
            res.put("issued", false);
            res.put("issue_user_id", issue_user_id);
            res.put("modification_id", self.getUserId());
            res.put("modification_value", request.getParameter("issueUrl"));
            res.put("verifyStartDay", this.webUtil.calUtil.formatCalendar(this.webUtil.calUtil.getCalendar(), "yyyy/MM/dd"));
            return mv;
        }
        catch (Exception e) {
            status.put("status", "Failed");
            status.put("message", "\u30c1\u30b1\u30c3\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            NyxException.logger.error((Object)"\u30c1\u30b1\u30c3\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            return mv;
        }
    }

    private List<User> loadTicket(ModelAndView mv, SsoManager ssoManager, Access access, User self) throws NyxException {
        ConditionList cond = new ConditionList(access);
        cond.add((Object)new Condition("user_type", (Object)"ticket"));
        cond.add((Object)new Condition("modification_id", (Object)self.getUserId()));
        return ssoManager.loadUser(0, 100, cond);
    }
}

