/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db.model;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import jp.nyx.common.util.CalendarUtility;

public class PortalNotice {
    private static CalendarUtility calUtil = new CalendarUtility();
    private Calendar now = Calendar.getInstance();
    private Calendar maxCal = Calendar.getInstance();
    private long seq;
    private String userId;
    private String userName;
    private String fromUserId;
    private String fromUserName;
    private String displayType = "one";
    private Timestamp displayStart;
    private Timestamp displayEnd;
    private String displayMode = "visible";
    private Timestamp noticeDate;
    private Timestamp receiveDate;
    private String url;
    private String title;
    private String message;
    private boolean enableTo = true;
    private boolean enableFrom = true;

    public PortalNotice() {
        this.maxCal.add(1, 100);
    }

    public Timestamp getDisplayEnd() {
        if (this.displayEnd == null) {
            this.displayEnd = new Timestamp(this.maxCal.getTimeInMillis());
        }
        return this.displayEnd;
    }

    public String getDisplayEndDay() {
        return calUtil.formatCalendar((Date)this.getDisplayEnd(), "yyyy/MM/dd");
    }

    public void setDisplayEnd(Timestamp displayEnd) {
        this.displayEnd = displayEnd;
    }

    public void setDisplayEnd(Calendar displayEnd) {
        if (displayEnd == null) {
            this.displayEnd = null;
            return;
        }
        this.displayEnd = new Timestamp(displayEnd.getTimeInMillis());
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public Timestamp getDisplayStart() {
        if (this.displayStart == null) {
            this.displayStart = new Timestamp(this.now.getTimeInMillis());
        }
        return this.displayStart;
    }

    public String getDisplayStartDay() {
        return calUtil.formatCalendar((Date)this.getDisplayStart(), "yyyy/MM/dd");
    }

    public void setDisplayStart(Timestamp displayStart) {
        this.displayStart = displayStart;
    }

    public void setDisplayStart(Calendar displayStart) {
        if (displayStart == null) {
            this.displayStart = null;
            return;
        }
        this.displayStart = new Timestamp(displayStart.getTimeInMillis());
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public boolean isEnableFrom() {
        return this.enableFrom;
    }

    public String getEnableFromString() {
        return this.enableFrom ? "t" : "f";
    }

    public void setEnableFrom(boolean enableFrom) {
        this.enableFrom = enableFrom;
    }

    public boolean isEnableTo() {
        return this.enableTo;
    }

    public String getEnableToString() {
        return this.enableTo ? "t" : "f";
    }

    public void setEnableTo(boolean enableTo) {
        this.enableTo = enableTo;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(String fromUserId) {
        this.fromUserId = fromUserId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Timestamp getNoticeDate() {
        if (this.noticeDate == null) {
            this.noticeDate = new Timestamp(this.now.getTimeInMillis());
        }
        return this.noticeDate;
    }

    public String getNoticeDay() {
        return calUtil.formatCalendar((Date)this.getNoticeDate(), "yyyy/MM/dd");
    }

    public void setNoticeDate(Timestamp noticeDate) {
        this.noticeDate = noticeDate;
    }

    public void setNoticeDate(Calendar noticeDate) {
        this.noticeDate = new Timestamp(noticeDate.getTimeInMillis());
    }

    public Timestamp getReceiveDate() {
        return this.receiveDate;
    }

    public String getReceiveDay() {
        if (this.receiveDate == null) {
            return null;
        }
        return calUtil.formatCalendar((Date)this.receiveDate, "yyyy/MM/dd");
    }

    public void setReceiveDate(Timestamp receiveDate) {
        this.receiveDate = receiveDate;
    }

    public void setReceiveDate(Calendar receiveDate) {
        this.receiveDate = new Timestamp(receiveDate.getTimeInMillis());
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

