/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.User;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class AuthController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String auth_type_search;
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        ssoManager.init((ApplicationContext)this.getWebApplicationContext());
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        String mode = request.getParameter("mode");
        mv.getModel().put("authTypes", Auth.AuthType.values());
        mv.getModel().put("authTypeMap", Auth.AuthType.getMap());
        mv.getModel().put("authUses", Auth.AuthUse.values());
        if ("user_search".equals(mode)) {
            ConditionList uc = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            uc.add((Object)new Condition("user_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            uc.setAccess(access);
            List<User> users = ssoManager.loadUser(0, 100, uc);
            mv.getModel().put("users", users);
            return mv;
        }
        if ("context_search".equals(mode)) {
            ConditionList cc = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            cc.add((Object)new Condition("context_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            List<Context> contexts = ssoManager.loadContext(0, 100, cc);
            mv.getModel().put("contexts", contexts);
            return mv;
        }
        if ("app_search".equals(mode)) {
            ConditionList sc = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            sc.add((Object)new Condition("site_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            sc.add((Object)new Condition("site_type", (Object)"app"));
            List<Site> apps = ssoManager.loadSite(0, 100, sc);
            mv.getModel().put("apps", apps);
            return mv;
        }
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        String auth_name_search = request.getParameter("auth_name_search");
        if (!this.webUtil.textUtil.isEmpty(auth_name_search)) {
            cond.add((Object)new Condition("auth_name", (Object)("%" + auth_name_search + "%"), "like"));
        }
        String string = auth_type_search = this.webUtil.textUtil.isEmpty(auth_type_search = request.getParameter("auth_type_search")) ? "BASIC_AUTH" : auth_type_search;
        if (!"all".equals(auth_type_search)) {
            cond.add((Object)new Condition("auth_type", (Object)auth_type_search));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_auth", cond));
        List<Auth> auths = ssoManager.loadAuth(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("auths", auths);
        if ("add".equals(mode)) {
            Auth auth = new Auth();
            mv.getModel().put("auth", auth);
            ConditionList c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"trigger"));
            List<Site> triggers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("triggers", triggers);
            c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"valid"));
            List<Site> valids = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("valids", valids);
            c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"failer"));
            List<Site> failers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("failers", failers);
        } else if ("adddo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Auth auth = new Auth();
                auth.setRegistUid(this.getRemoteUser(mv));
                auth.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(auth, request, status, ssoManager)) {
                    return mv;
                }
                ssoManager.saveAuth(auth);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(mode)) {
            Auth auth = ssoManager.loadAuth(this.webUtil.numUtil.parseInt(request.getParameter("auth_id")));
            mv.getModel().put("auth", auth);
            ConditionList c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"trigger"));
            List<Site> triggers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("triggers", triggers);
            c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"valid"));
            List<Site> valids = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("valids", valids);
            c = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
            c.add((Object)new Condition("site_type", (Object)"failer"));
            List<Site> failers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("failers", failers);
        } else if ("editdo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Auth auth = ssoManager.loadAuth(this.webUtil.numUtil.parseInt(request.getParameter("auth_id")));
                if (!this.save(auth, request, status, ssoManager)) {
                    return mv;
                }
                auth.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveAuth(auth);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deleteAuth(this.webUtil.numUtil.parseInt(request.getParameter("auth_id")));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(Auth auth, HttpServletRequest request, Map<String, String> status, SsoManager ssoManager) throws NoSuchAlgorithmException, MessagingException, IOException, NyxException {
        int i;
        String auth_name = request.getParameter("auth_name");
        if (this.webUtil.textUtil.isEmpty(auth_name)) {
            status.put("status", "Failed");
            status.put("message", "\u6a29\u9650\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        auth.setAuthName(auth_name);
        auth.setAuthType(request.getParameter("auth_type"));
        auth.setAuthUse(request.getParameter("auth_use"));
        auth.setTriggerSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("trigger_site_id")));
        auth.setValidSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("valid_site_id")));
        auth.setFailerSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("failer_site_id")));
        String[] users = request.getParameterValues("user");
        Set ref = auth.getUser();
        ref.clear();
        for (i = 0; users != null && i < users.length; ++i) {
            ref.add(ssoManager.loadUser(users[i]));
        }
        String[] contexts = request.getParameterValues("context");
        ref = auth.getContext();
        ref.clear();
        for (i = 0; contexts != null && i < contexts.length; ++i) {
            ref.add(ssoManager.loadContext(this.webUtil.numUtil.parseInt(contexts[i])));
        }
        String[] apps = request.getParameterValues("app");
        ref = auth.getAppSiteId();
        ref.clear();
        for (i = 0; apps != null && i < apps.length; ++i) {
            ref.add(ssoManager.loadSite(this.webUtil.numUtil.parseInt(apps[i])));
        }
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                Calendar cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                auth.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            auth.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                Calendar cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                auth.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            auth.setVerifyEnddate(null);
        }
        auth.setValidTicket("true".equals(request.getParameter("valid_ticket")));
        auth.setEnable("true".equals(request.getParameter("enable")));
        return true;
    }
}

