/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;

public class ProxyServlet
extends HttpServlet {
    private static final WebUtility webUtil = new WebUtility();
    private static final Pattern pattern = Pattern.compile("[0-9]{3}");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long tm = System.currentTimeMillis();
        Map nyx = (Map)request.getAttribute("nyxSetting");
        boolean verbose = "on".equals(((Setting)nyx.get("kernel_log_verbose")).getValue());
        AccessValidaterUtility.AuthValue authValue = (AccessValidaterUtility.AuthValue)request.getAttribute("authValue");
        if (authValue == null) {
            webUtil.redirectError(request, response, 400, "No filtered request, from SSOFilter.", null);
            return;
        }
        URL site = authValue.getValidSite();
        String use = authValue.getAuthUse();
        if (site == null) {
            this.warmLog(tm, System.currentTimeMillis(), authValue, "Valid site is null.");
            webUtil.sendAuthenticate(request, response, null);
            return;
        }
        if (Auth.AuthUse.FORWARD.getValue().equals(use)) {
            if (verbose) {
                this.debugLog(tm, System.currentTimeMillis(), authValue, "Request dispatch to '" + site + "'.");
            }
            webUtil.sendRedirect(this.getServletContext(), request, response, webUtil.createQueryPath(site));
            return;
        }
        try {
            StringBuilder remoteReqest = new StringBuilder();
            remoteReqest.append(request.getMethod());
            remoteReqest.append(" ");
            remoteReqest.append(webUtil.createQueryPath(site));
            remoteReqest.append(" HTTP/1.0\r\n");
            Enumeration headNames = request.getHeaderNames();
            while (headNames.hasMoreElements()) {
                String n = ((String)headNames.nextElement()).toLowerCase();
                if (n.equals("host") || n.equals("if-none-match") || n.equals("connection") || n.equals("keep-alive") || n.equals("proxy-authenticate") || n.equals("proxy-authorization") || n.equals("transfer-encoding") || n.equals("upgrade") || n.equals("trailers") || n.equals("te")) continue;
                remoteReqest.append(n);
                remoteReqest.append(":");
                Enumeration values = request.getHeaders(n);
                boolean d = false;
                while (values.hasMoreElements()) {
                    String v = (String)values.nextElement();
                    if (ProxyServlet.webUtil.textUtil.isEmpty(v)) continue;
                    if (d) {
                        remoteReqest.append(",");
                    }
                    remoteReqest.append(v);
                    d = true;
                }
                remoteReqest.append("\r\n");
            }
            StringBuffer v = new StringBuffer("xmlrpc=");
            v.append(((Setting)nyx.get("kernel_xmlrpc_url")).getValue());
            remoteReqest.append("NyxAuthGate");
            remoteReqest.append(":");
            remoteReqest.append(v);
            remoteReqest.append("\r\n");
            response.addHeader("NyxAuthGate", v.toString());
            remoteReqest.append("Connection: close\r\n");
            remoteReqest.append("Host:");
            remoteReqest.append(site.getHost());
            if (site.getPort() > 0) {
                remoteReqest.append(":");
                remoteReqest.append(site.getPort());
            }
            remoteReqest.append("\r\n");
            remoteReqest.append("\r\n");
            Socket socket = new Socket(site.getHost(), this.getPort(site));
            socket.setSoTimeout(60000);
            if (verbose) {
                this.debugLog(tm, System.currentTimeMillis(), authValue, "\n[\u4e0a\u308a]\n" + remoteReqest.toString());
            }
            OutputStream out = socket.getOutputStream();
            out.write(remoteReqest.toString().getBytes());
            webUtil.pipe((InputStream)request.getInputStream(), out);
            StringBuilder remoteResponce = new StringBuilder();
            BufferedInputStream bin = new BufferedInputStream(socket.getInputStream());
            try {
                String line = this.readLine(bin);
                Matcher m = pattern.matcher(line);
                if (m.find()) {
                    response.setStatus(Integer.parseInt(m.group()));
                }
                while (!ProxyServlet.webUtil.textUtil.isEmpty(line = this.readLine(bin))) {
                    String v2;
                    String n;
                    block30: {
                        int i = line.indexOf(":");
                        if (i <= 1) continue;
                        n = line.substring(0, i);
                        String nl = n.toLowerCase();
                        v2 = line.substring(i + 1);
                        if (nl.equals("location")) {
                            URL tu = authValue.getTriggerSite();
                            try {
                                String ph = webUtil.createQueryPath(new URL(v2));
                                v2 = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), ph).toString();
                            }
                            catch (MalformedURLException e) {
                                if (v2.startsWith("/")) {
                                    v2 = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), v2).toString();
                                    break block30;
                                }
                                URL u = new URL(request.getRequestURL().toString());
                                String ph = u.getPath();
                                String qu = u.getQuery();
                                ph = ph.substring(0, ph.lastIndexOf("/")) + '/' + v2.trim();
                                if (!ProxyServlet.webUtil.textUtil.isEmpty(qu)) {
                                    ph = ph + '?' + qu;
                                }
                                v2 = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), ph).toString();
                            }
                        } else if (nl.equals("set-cookie")) {
                            StringBuilder sb = new StringBuilder();
                            String[] pt = v2.split(";");
                            for (int j = 0; j < pt.length; ++j) {
                                if (ProxyServlet.webUtil.textUtil.isEmpty(pt[j])) continue;
                                if (j > 0) {
                                    sb.append(";");
                                }
                                if (pt[j].startsWith("domain")) {
                                    sb.append("domain=");
                                    sb.append(((Setting)nyx.get("base_host")).getValue());
                                    continue;
                                }
                                sb.append(pt[j]);
                            }
                            v2 = sb.toString();
                        } else if (nl.equals("connection")) continue;
                    }
                    remoteResponce.append(n);
                    remoteResponce.append(":");
                    remoteResponce.append(v2);
                    remoteResponce.append("\r\n");
                    response.addHeader(n, v2);
                }
                if (verbose) {
                    this.debugLog(tm, System.currentTimeMillis(), authValue, "\n[\u4e0b\u308a]\n" + remoteResponce.toString());
                }
                webUtil.pipe((InputStream)bin, (OutputStream)response.getOutputStream());
            }
            catch (SocketTimeoutException e) {
                this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
                webUtil.redirectError(request, response, 504, e.getMessage(), authValue.getFailerSite());
            }
            catch (SocketException e) {
                this.warmLog(tm, System.currentTimeMillis(), authValue, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u30b3\u30f3\u30c6\u30f3\u30c4\u9001\u4fe1\u4e2d\u306b\u63a5\u7d9a\u304c\u9589\u3058\u3089\u308c\u307e\u3057\u305f\u3002" + e.getMessage());
            }
            bin.close();
            socket.close();
        }
        catch (ConnectException e) {
            this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
            webUtil.redirectError(request, response, 504, e.getMessage(), authValue.getFailerSite());
        }
        catch (Exception e) {
            ServletException ex = new ServletException((Throwable)e);
            ex.initCause((Throwable)e);
            this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
            throw ex;
        }
        if (verbose) {
            this.debugLog(tm, System.currentTimeMillis(), authValue, "Proxy complate.");
        }
    }

    private void warmLog(long proxyStart, long proxyEnd, AccessValidaterUtility.AuthValue value, String message) {
        if (!NyxException.logger.isWarnEnabled()) {
            return;
        }
        long proxyTime = proxyEnd - proxyStart;
        StringBuffer sb = new StringBuffer("\u8ee2\u9001:");
        URL tu = value.getTriggerSite();
        NyxException.logger.warn((Object)sb.append(proxyTime).append("ms").append(" Type=").append(value.getAuthType()).append(" Use=").append(value.getAuthUse()).append(" User=").append(value.getUserId()).append(" Client=").append(value.getClientAddress()).append(" Trigger=[").append(value.getTriggerMethod()).append("]").append(tu.getPath()).append(" ValidSite=").append(value.getValidSite()).append(" Cause=").append(value.getLog()).append(" Message=").append(message).append(" Session=").append(value.getSessionId()));
    }

    private void debugLog(long proxyStart, long proxyEnd, AccessValidaterUtility.AuthValue value, String message) {
        if (!NyxException.logger.isDebugEnabled()) {
            return;
        }
        long proxyTime = proxyEnd - proxyStart;
        URL tu = value.getTriggerSite();
        StringBuffer sb = new StringBuffer("\u8ee2\u9001:");
        NyxException.logger.debug((Object)sb.append(proxyTime).append("ms").append(" Type=").append(value.getAuthType()).append(" Use=").append(value.getAuthUse()).append(" User=").append(value.getUserId()).append(" Client=").append(value.getClientAddress()).append(" Trigger=[").append(value.getTriggerMethod()).append("]").append(tu.getPath()).append(" ValidSite=").append(value.getValidSite()).append(" Cause=").append(value.getLog()).append(" Message=").append(message).append(" Session=").append(value.getSessionId()));
    }

    private int getPort(URL site) {
        int port = site.getPort();
        if (port > 0) {
            return port;
        }
        if ("http".equals(site.getProtocol())) {
            return 80;
        }
        if ("https".equals(site.getProtocol())) {
            return 443;
        }
        return 80;
    }

    private String readLine(BufferedInputStream bin) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        boolean r = false;
        int i = -1;
        while ((i = bin.read()) > 0) {
            if (i == 13) {
                r = true;
                continue;
            }
            if (r && i == 10) break;
            b.write(i);
        }
        b.close();
        return new String(b.toByteArray());
    }
}

