/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.User;
import jp.nyx.common.web.DefaultController;
import jp.nyx.pkg.sso.db.SsoManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class SsoController
extends DefaultController {
    public static final String PARAM_KEY_OFFSET = "offset";
    public static final String PARAM_KEY_LIMIT = "limit";
    public static final String PARAM_KEY_ROWCOUNT = "rowcount";
    public static final String PARAM_KEY_PAGECOUNT = "pagecount";
    public static final String PARAM_KEY_REMOTEUSERID = "remote_user";
    public static final String ATTR_PERSONAL_ACCESS = "personal_access";

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        Map<String, Object> res = this.getRes(mv);
        res.put(PARAM_KEY_OFFSET, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_OFFSET), 0));
        res.put(PARAM_KEY_LIMIT, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_LIMIT), 20));
        res.put(PARAM_KEY_ROWCOUNT, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_ROWCOUNT), 0));
        res.put(PARAM_KEY_PAGECOUNT, 0);
        String uid = (String)request.getAttribute("nyxUserId");
        res.put(PARAM_KEY_REMOTEUSERID, uid);
        Access access = AccessFactory.createAccess(PersonalAccess.class);
        request.setAttribute(ATTR_PERSONAL_ACCESS, (Object)access);
        SsoManager ssoManager = this.getSsoManager();
        if (ssoManager.isInit(super.getApplicationContext())) {
            HttpSession sesson = request.getSession(true);
            Object u = sesson.getAttribute("self_user_object");
            if (u == null || !(u instanceof User)) {
                User self = ssoManager.loadUser(uid);
                access.setSelf(self);
            } else {
                access.setSelf((User)u);
            }
        }
        access.setAdmin(this.isAdminUser(request));
        access.setPersonalAdmin(this.isPersonalAdminUser(request));
        return mv;
    }

    protected SsoManager getSsoManager() {
        WebApplicationContext appCtx = super.getWebApplicationContext();
        return (SsoManager)appCtx.getBean("ssoManager");
    }

    protected Access getPersonalAccess(HttpServletRequest request) {
        return (Access)request.getAttribute(ATTR_PERSONAL_ACCESS);
    }

    protected int getOffset(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_OFFSET);
    }

    protected int getLimit(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_LIMIT);
    }

    protected String getRemoteUser(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (String)res.get(PARAM_KEY_REMOTEUSERID);
    }

    protected int getRowcount(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_ROWCOUNT);
    }

    protected void setRowcount(ModelAndView mv, int rowcount) {
        Map<String, Object> res = this.getRes(mv);
        res.put(PARAM_KEY_ROWCOUNT, rowcount);
        int limit = (Integer)res.get(PARAM_KEY_LIMIT);
        int pc = rowcount / limit;
        pc = rowcount % limit > 0 ? pc + 1 : pc;
        res.put(PARAM_KEY_PAGECOUNT, pc);
    }
}

