/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.extractor;

import com.sk_jp.xml.DOMUtility;
import com.sk_jp.xml.extractor.Extractor;
import org.w3c.dom.Node;

public class ContentRangeExtractor
implements Extractor {
    private double min_;
    private double max_;

    public ContentRangeExtractor(double d, double d2) {
        this.min_ = d;
        this.max_ = d2;
    }

    public boolean canExtract(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        String string = DOMUtility.getContentString(node);
        if (string == null) {
            return false;
        }
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                if (d < this.min_ || this.max_ < d) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "[ContentValueRange = " + this.min_ + "-" + this.max_ + "]";
    }
}

