/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class NyxLicense
implements Serializable {
    private static final long serialVersionUID = 567122484718844827L;
    public static final String KERNEL_TITLE = "Nyx Kernel";
    public static final String KERNEL_VERSION = "0.5.9.e";
    public static final String KERNEL_COPY = "Copyright (C) 2005-2008 Nyx Project. All right reserved.";
    public static final String KERNEL_OWNER = "Y.Hamanaka at 2005-th";
    public static final String KERNEL_EXTJS = "Ext 2.0 by extjs.com";
    public static final boolean REVIEW_VERSION = false;
    private static File LICENSE_FILE = new File("nyx.ser");
    private static boolean valid = false;
    private static String licenseLimit = "";
    private Calendar limit;

    private NyxLicense(Calendar limit) {
        this.limit = limit;
    }

    public static void validLicense() {
        if (valid) {
            return;
        }
        valid = true;
    }

    private static NyxLicense getValidLicenseKey() {
        try {
            if (!LICENSE_FILE.exists()) {
                Calendar limit = Calendar.getInstance();
                limit.add(2, 3);
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(LICENSE_FILE));
                out.writeObject(new NyxLicense(limit));
                out.close();
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(LICENSE_FILE));
            NyxLicense ret = (NyxLicense)in.readObject();
            in.close();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            licenseLimit = format.format(ret.limit.getTime());
            return ret;
        }
        catch (Exception e) {
            InstantiationError err = new InstantiationError("\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u304c\u7121\u52b9\u3067\u3059\u3002");
            err.initCause(e);
            throw err;
        }
    }

    public static String getLicenseLimit() {
        return licenseLimit;
    }

    public static final String getProjectDescription() {
        StringBuilder ret = new StringBuilder();
        ret.append("\u3053\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306f\u3001\u958b\u767a\u3057\u305f\u30bd\u30d5\u30c8\u30a6\u30a8\u30a2\u3092\u30aa\u30fc\u30d7\u30f3\u30bd\u30fc\u30b9\u3068\u3057\u3066\u516c\u958b\u3057\u3001");
        ret.append("\u591a\u304f\u306e\u958b\u767a\u30fb\u69cb\u7bc9\u30fb\u904b\u7528\u306e\u73fe\u5834\u3067\u5e83\u304f\u4f7f\u308f\u308c\u308b\u3053\u3068\u3092\u76ee\u7684\u3068\u3057\u3066\u3044\u307e\u3059\u3002\n");
        ret.append("\u3053\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306fWeb\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3084\u30e1\u30fc\u30eb\u30fbSSH\u306a\u3069\u306e\u30ea\u30e2\u30fc\u30c8\u30ed\u30b0\u30a4\u30f3\u5411\u3051\u306b\u3001");
        ret.append("\u7d71\u5408\u3055\u308c\u305fSSO\u30b5\u30fc\u30d0\u30fc\u30b7\u30b9\u30c6\u30e0\u3092\u958b\u767a\u3057\u307e\u3059\u3002\n");
        ret.append("SourceForge\u306eCVS\u3084\u63b2\u793a\u677f\u3092\u5229\u7528\u3059\u308b\u3053\u3068\u3067\u3001\u7b2c\u4e00\u7dda\u3067\u50cd\u304f\u6280\u8853\u8005\u3068\u306e\u4ea4\u6d41\u304c\u6301\u3066\u3001");
        ret.append("\u958b\u767a\u3055\u308c\u308b\u30bd\u30d5\u30c8\u30a6\u30a8\u30a2\u304c\u3088\u308a\u300c\u4f7f\u3048\u308b\u300d\u30b7\u30b9\u30c6\u30e0\u306b\u306a\u308b\u3053\u3068\u3092\u671f\u5f85\u3057\u3066\u3044\u307e\u3059\u3002");
        return ret.toString();
    }

    static {
        NyxLicense.validLicense();
    }
}

