/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.User;

public class Auth
extends DefaultModel
implements Comparable<Auth> {
    private long authId;
    private String authName;
    private Site triggerSiteId;
    private String authType;
    private String authUse;
    private long tieupCode;
    private Site validSiteId;
    private Site failerSiteId;
    private boolean validTicket = false;
    private Map<String, Ext> ext = new TreeMap<String, Ext>();
    private Set<Site> appSiteId = new TreeSet<Site>();
    private Set<Site> informSiteId = new TreeSet<Site>();
    private Set<Context> context = new TreeSet<Context>();
    private Set<User> user = new TreeSet<User>();

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return (int)this.authId;
    }

    @Override
    public int compareTo(Auth t) {
        String ns = this.getAuthName();
        String nt = t == null ? "" : t.getAuthName();
        return ns.compareTo(nt);
    }

    public String getAuthName() {
        return txtUtil.nvl(this.authName);
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public long getAuthId() {
        return this.authId;
    }

    public void setAuthId(long authId) {
        this.authId = authId;
    }

    public String getAuthType() {
        return txtUtil.nvl(this.authType);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthUse() {
        return txtUtil.nvl(this.authUse);
    }

    public void setAuthUse(String authUse) {
        this.authUse = authUse;
    }

    public Site getFailerSiteId() {
        return this.failerSiteId;
    }

    public Long getFailerSiteIdLong() {
        if (this.failerSiteId == null) {
            return null;
        }
        return this.failerSiteId.getSiteId();
    }

    public void setFailerSiteId(Site failerSiteId) {
        this.failerSiteId = failerSiteId;
    }

    public void setFailerSiteIdInt(long failerSiteId) {
        if (failerSiteId <= 0L) {
            return;
        }
        this.failerSiteId = new Site();
        this.failerSiteId.setSiteId(failerSiteId);
    }

    public Site getTriggerSiteId() {
        return this.triggerSiteId;
    }

    public Long getTriggerSiteIdInt() {
        if (this.triggerSiteId == null) {
            return null;
        }
        return this.triggerSiteId.getSiteId();
    }

    public void setTriggerSiteId(Site triggerSiteId) {
        this.triggerSiteId = triggerSiteId;
    }

    public void setTriggerSiteIdInt(long triggerSiteId) {
        if (triggerSiteId <= 0L) {
            return;
        }
        this.triggerSiteId = new Site();
        this.triggerSiteId.setSiteId(triggerSiteId);
    }

    public Site getValidSiteId() {
        return this.validSiteId;
    }

    public Long getValidSiteIdInt() {
        if (this.validSiteId == null) {
            return null;
        }
        return this.validSiteId.getSiteId();
    }

    public void setValidSiteId(Site validSiteId) {
        this.validSiteId = validSiteId;
    }

    public void setValidSiteIdInt(long validSiteId) {
        if (validSiteId <= 0L) {
            return;
        }
        this.validSiteId = new Site();
        this.validSiteId.setSiteId(validSiteId);
    }

    public Set<Site> getAppSiteId() {
        return this.appSiteId;
    }

    public Set<Site> getInformSiteId() {
        return this.informSiteId;
    }

    public Set<Context> getContext() {
        return this.context;
    }

    public Map<String, Ext> getExt() {
        return this.ext;
    }

    public Set<User> getUser() {
        return this.user;
    }

    public boolean isValidTicket() {
        return this.validTicket;
    }

    public String getValidTicketString() {
        return this.validTicket ? "t" : "f";
    }

    public void setValidTicket(boolean validTicket) {
        this.validTicket = validTicket;
    }

    public long getTieupCode() {
        return this.tieupCode;
    }

    public void setTieupCode(long tieupCode) {
        this.tieupCode = tieupCode;
    }

    public static enum AuthExtNames {
        PROXY_REQPARAM_CHARENCODE("PROXY_REQPARAM_CHARENCODE", "Proxy\u6642\u30d1\u30e9\u30e1\u30fc\u30bf\u6587\u5b57\u30a8\u30f3\u30b3\u30fc\u30c9");

        private String value;
        private String text;

        private AuthExtNames(String value, String text) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(AuthExtNames.PROXY_REQPARAM_CHARENCODE.text, AuthExtNames.PROXY_REQPARAM_CHARENCODE.value);
            return ret;
        }
    }

    public static enum AuthType {
        BASIC("BASIC_AUTH", "\u57fa\u672c\u8a8d\u8a3c"),
        PASSED("PASSED_AUTH", "\u5e38\u6642\u8a8d\u53ef"),
        PARAM("PARAM_AUTH", "\u30d1\u30e9\u30e1\u30fc\u30bf\u8a8d\u8a3c"),
        LISTEN("LISTEN_AUTH", "\u76d7\u8074\u8a8d\u8a3c"),
        OPENID_DUMB_SETUP("OPENID_DUMB_SETUP_AUTH", "OpenID\u8a8d\u8a3c[dump+setup]");

        private String value;
        private String text;

        private AuthType(String value, String text) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(AuthType.BASIC.text, AuthType.BASIC.value);
            ret.put(AuthType.PASSED.text, AuthType.PASSED.value);
            ret.put(AuthType.LISTEN.text, AuthType.LISTEN.value);
            ret.put(AuthType.PARAM.text, AuthType.PARAM.value);
            ret.put(AuthType.OPENID_DUMB_SETUP.text, AuthType.OPENID_DUMB_SETUP.value);
            return ret;
        }

        public static boolean isOpenidType(String typeText) {
            return AuthType.OPENID_DUMB_SETUP.text.equals(typeText);
        }
    }

    public static enum AuthUse {
        PROXY("sso_proxy", "SSO(Proxy\u30bf\u30a4\u30d7)"),
        FORWARD("sso_forward", "SSO(Forward\u30bf\u30a4\u30d7)");

        private String value;
        private String text;

        private AuthUse(String value, String text) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

