/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.nyx.common.db.model.ContextBridge;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.User;

public class Context
extends DefaultModel
implements Comparable<Context> {
    private long contextCode;
    private String contextType;
    private String contextName;
    private Map<String, Ext> ext = new TreeMap<String, Ext>();
    private Set<User> owner = new TreeSet<User>();
    private Set<User> user = new TreeSet<User>();
    private Set<ContextBridge> bridge = new TreeSet<ContextBridge>();

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return (int)this.contextCode;
    }

    @Override
    public int compareTo(Context t) {
        String ns = this.getContextName();
        String nt = t == null ? "" : t.getContextName();
        return ns.compareTo(nt);
    }

    public String getContextName() {
        return txtUtil.nvl(this.contextName);
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextType() {
        return txtUtil.nvl(this.contextType);
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }

    public Map<String, Ext> getExt() {
        return this.ext;
    }

    public Set<User> getOwner() {
        return this.owner;
    }

    public Set<User> getUser() {
        return this.user;
    }

    public long getContextCode() {
        return this.contextCode;
    }

    public void setContextCode(long contextCode) {
        this.contextCode = contextCode;
    }

    public Set<ContextBridge> getBridge() {
        return this.bridge;
    }

    public static enum ContextType {
        GROUP("group", "\u30b0\u30eb\u30fc\u30d7", true),
        OPERATOR("operator", "\u904b\u7528\u30b0\u30eb\u30fc\u30d7", true),
        NESTED("nested", "\u89aa\u30b0\u30eb\u30fc\u30d7", true),
        APP("app", "\u30a2\u30d7\u30ea\u56fa\u6709", false),
        WR("wr", "\u30a2\u30d7\u30ea\u56fa\u6709(WR)", false);

        private String value;
        private String text;
        private boolean visible = true;

        private ContextType(String value, String text, boolean visible) {
            this.text = text;
            this.value = value;
            this.visible = visible;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public static ContextType[] visibleValues() {
            return new ContextType[]{GROUP, OPERATOR, NESTED};
        }

        public static Map<String, String> getVisibleMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(ContextType.GROUP.value, ContextType.GROUP.text);
            ret.put(ContextType.OPERATOR.value, ContextType.OPERATOR.text);
            ret.put(ContextType.NESTED.value, ContextType.NESTED.text);
            return ret;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(ContextType.GROUP.text, ContextType.GROUP.value);
            ret.put(ContextType.OPERATOR.text, ContextType.OPERATOR.value);
            ret.put(ContextType.NESTED.text, ContextType.NESTED.value);
            ret.put(ContextType.APP.text, ContextType.APP.value);
            ret.put(ContextType.WR.text, ContextType.WR.value);
            return ret;
        }
    }
}

