/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.app.old;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jp.nyx.pkg.app.old.NoticeWeb;

public class ForumWeb
extends NoticeWeb {
    public static final int HOT_COUNT_VALUE = 100;
    private DataSource forumDb;

    public void init(ServletContext context, HttpServletRequest request, String authDsName, String noticeDsName, String forumDsName, String adrDsName) throws NamingException, IOException, SQLException {
        super.init(context, request, authDsName, noticeDsName, adrDsName);
        this.forumDb = super.lookup(forumDsName);
    }

    public Connection forumBegin() throws SQLException {
        Connection con = this.getConnection(this.forumDb);
        con.setAutoCommit(false);
        return con;
    }

    public boolean loadCategoryOwner(Connection forumCon, String category_id) throws SQLException {
        PreparedStatement catOwnBLSt = this.createStatement(forumCon, "select * from t_category_owner where category_id=? and user_id=?");
        catOwnBLSt.setString(1, category_id);
        catOwnBLSt.setString(2, this.getRemoteUser());
        ResultSet catOwnBLRs = catOwnBLSt.executeQuery();
        boolean catOwnBL = catOwnBLRs.next();
        catOwnBLSt.close();
        return catOwnBL;
    }

    protected boolean loadForumOwner(Connection forumCon, String forum_id) throws SQLException {
        PreparedStatement forumOwnBLSt = this.createStatement(forumCon, "select * from t_forum_owner where forum_id=? and user_id=?");
        forumOwnBLSt.setString(1, forum_id);
        forumOwnBLSt.setString(2, this.getRemoteUser());
        ResultSet forumOwnBLRs = forumOwnBLSt.executeQuery();
        boolean forumOwnBL = forumOwnBLRs.next();
        forumOwnBLSt.close();
        return forumOwnBL;
    }

    protected boolean loadForumMember(Connection forumCon, String forum_id) throws SQLException {
        PreparedStatement forumMemBLSt = this.createStatement(forumCon, "select * from t_forum_member where forum_id=? and user_id=?");
        forumMemBLSt.setString(1, forum_id);
        forumMemBLSt.setString(2, this.getRemoteUser());
        ResultSet forumMemBLRs = forumMemBLSt.executeQuery();
        boolean forumMemBL = forumMemBLRs.next();
        forumMemBLSt.close();
        return forumMemBL;
    }

    protected boolean loadTopicOwner(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement topicOwnBLSt = this.createStatement(forumCon, "select * from t_topic_owner where topic_id=? and user_id=?");
        topicOwnBLSt.setString(1, topic_id);
        topicOwnBLSt.setString(2, this.getRemoteUser());
        ResultSet topicOwnBLRs = topicOwnBLSt.executeQuery();
        boolean topicOwnBL = topicOwnBLRs.next();
        topicOwnBLSt.close();
        return topicOwnBL;
    }

    protected boolean loadTopicMember(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement topicMemBLSt = this.createStatement(forumCon, "select * from t_topic_member where topic_id=? and user_id=?");
        topicMemBLSt.setString(1, topic_id);
        topicMemBLSt.setString(2, this.getRemoteUser());
        ResultSet topicMemBLRs = topicMemBLSt.executeQuery();
        boolean topicMemBL = topicMemBLRs.next();
        topicMemBLSt.close();
        return topicMemBL;
    }

    public ResultSet loadCategory(Connection forumCon, String category_id) throws SQLException {
        PreparedStatement catSt = this.createStatement(forumCon, "select * from t_category where category_id=?");
        catSt.setString(1, category_id);
        return catSt.executeQuery();
    }

    public ResultSet loadForum(Connection forumCon, String forum_id) throws SQLException {
        PreparedStatement forumSt = this.createStatement(forumCon, "select * from t_forum where forum_id=?");
        forumSt.setString(1, forum_id);
        return forumSt.executeQuery();
    }

    public ResultSet loadTopic(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement topicSt = this.createStatement(forumCon, "select * from t_topic where topic_id=?");
        topicSt.setString(1, topic_id);
        return topicSt.executeQuery();
    }

    public ResultSet loadPost(Connection forumCon, String post_id) throws SQLException {
        PreparedStatement postSt = this.createStatement(forumCon, "select * from t_post where post_id=?");
        postSt.setString(1, post_id);
        return postSt.executeQuery();
    }

    public boolean loadForumAddUser(Connection forumCon, String category_id) throws SQLException {
        return this.loadCategoryOwner(forumCon, category_id);
    }

    public boolean loadTopicAddUser(Connection forumCon, String forum_id, String forum_status, String topic_newmode) throws SQLException {
        boolean ret = true;
        boolean own = this.loadForumOwner(forumCon, forum_id);
        boolean mem = this.loadForumMember(forumCon, forum_id);
        ret = "viewonly".equals(forum_status) ? false : ret;
        ret = "hidden".equals(forum_status) ? false : ret;
        ret = "owner".equals(topic_newmode) ? false : ret;
        ret = !mem && "member".equals(topic_newmode) ? false : ret;
        ret = own ? true : ret;
        return ret;
    }

    public boolean loadPostAddUser(Connection forumCon, String topic_id, String topic_status, String post_newmode) throws SQLException {
        boolean ret = true;
        boolean own = this.loadTopicOwner(forumCon, topic_id);
        boolean mem = this.loadTopicMember(forumCon, topic_id);
        ret = "viewonly".equals(topic_status) ? false : ret;
        ret = "hidden".equals(topic_status) ? false : ret;
        ret = "owner".equals(post_newmode) ? false : ret;
        ret = !mem && "member".equals(post_newmode) ? false : ret;
        ret = own ? true : ret;
        return ret;
    }

    public boolean loadForumEditUser(Connection forumCon, String category_id, String forum_id, String forum_status) throws SQLException {
        boolean ret = false;
        boolean catOwn = this.loadCategoryOwner(forumCon, category_id);
        boolean forOwn = this.loadForumOwner(forumCon, forum_id);
        ret = catOwn || forOwn ? true : ret;
        return ret;
    }

    public boolean loadTopicEditUser(Connection forumCon, String forum_id, String topic_id, String topic_status, String topic_editmode) throws SQLException {
        boolean ret = true;
        boolean forOwn = this.loadForumOwner(forumCon, forum_id);
        boolean topOwn = this.loadTopicOwner(forumCon, topic_id);
        boolean mem = this.loadTopicMember(forumCon, topic_id);
        ret = "viewonly".equals(topic_status) ? false : ret;
        ret = "hidden".equals(topic_status) ? false : ret;
        ret = "owner".equals(topic_editmode) ? false : ret;
        ret = !mem && "member".equals(topic_editmode) ? false : ret;
        ret = forOwn || topOwn ? true : ret;
        return ret;
    }

    public boolean loadPostEditUser(Connection forumCon, String topic_id, String post_user_id, String post_status, String post_editmode) throws SQLException {
        boolean ret = true;
        boolean topOwn = this.loadTopicOwner(forumCon, topic_id);
        boolean postOwn = this.getRemoteUser().equals(post_user_id);
        boolean mem = this.loadTopicMember(forumCon, topic_id);
        ret = "viewonly".equals(post_status) ? false : ret;
        ret = "hidden".equals(post_status) ? false : ret;
        ret = "owner".equals(post_editmode) ? false : ret;
        ret = "user".equals(post_editmode) ? false : ret;
        ret = !mem && "member".equals(post_editmode) ? false : ret;
        ret = topOwn || postOwn ? true : ret;
        return ret;
    }

    public boolean loadForumViewUser(Connection forumCon, String category_id, String forum_id, String forum_status, String forum_viewmode) throws SQLException {
        boolean ret = true;
        boolean catOwn = this.loadCategoryOwner(forumCon, category_id);
        boolean forOwn = this.loadForumOwner(forumCon, forum_id);
        boolean mem = this.loadForumMember(forumCon, forum_id);
        ret = "hidden".equals(forum_status) ? false : ret;
        ret = !mem && "member".equals(forum_viewmode) ? false : ret;
        ret = catOwn || forOwn ? true : ret;
        return ret;
    }

    public boolean loadTopicViewUser(Connection forumCon, String forum_id, String topic_id, String topic_status, String topic_viewmode) throws SQLException {
        boolean ret = true;
        boolean forOwn = this.loadForumOwner(forumCon, forum_id);
        boolean topOwn = this.loadTopicOwner(forumCon, topic_id);
        boolean mem = this.loadTopicMember(forumCon, topic_id);
        ret = "hidden".equals(topic_status) ? false : ret;
        ret = !mem && "member".equals(topic_viewmode) ? false : ret;
        ret = forOwn || topOwn ? true : ret;
        return ret;
    }

    public boolean loadPostViewUser(Connection forumCon, String topic_id, String post_user_id, String post_status) throws SQLException {
        boolean ret = true;
        boolean topOwn = this.loadTopicOwner(forumCon, topic_id);
        boolean postOwn = this.getRemoteUser().equals(post_user_id);
        ret = "hidden".equals(post_status) ? false : ret;
        ret = topOwn || postOwn ? true : ret;
        return ret;
    }

    public boolean loadViewPostForTopic(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement st = this.createStatement(forumCon, "select p1.post_id as post_id from t_post p1 left join (select post_id from t_post_viewinfo where user_id=? and view_status='view' ) p2 on (p1.post_id=p2.post_id) where p2.post_id is null and p1.topic_id=?");
        st.setString(1, this.getRemoteUser());
        st.setString(2, topic_id);
        ResultSet rs = st.executeQuery();
        boolean ret = rs.next();
        st.close();
        return ret;
    }

    public boolean loadViewPostForForum(Connection forumCon, String forum_id) throws SQLException {
        PreparedStatement st = this.createStatement(forumCon, "select t.topic_id, p.post_id from t_topic t, (select p1.topic_id as topic_id, p1.post_id as post_id from t_post p1 left join (select post_id from t_post_viewinfo where user_id=? and view_status='view' ) p2 on (p1.post_id=p2.post_id) where p2.post_id is null) p where t.topic_id=p.topic_id and forum_id=?");
        st.setString(1, this.getRemoteUser());
        st.setString(2, forum_id);
        ResultSet rs = st.executeQuery();
        boolean ret = rs.next();
        st.close();
        return ret;
    }

    public void updateForumLastUpUser(Connection forumCon, String forum_id) throws SQLException {
        PreparedStatement st = this.createStatement(forumCon, "update t_forum set last_update=now(), last_update_user_id=? where forum_id=?");
        st.setString(1, this.getRemoteUser());
        st.setString(2, forum_id);
        st.executeUpdate();
        st.close();
    }

    public void updateTopicLastUpUser(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement st = this.createStatement(forumCon, "update t_topic set last_update=now(), last_update_user_id=? where topic_id=?");
        st.setString(1, this.getRemoteUser());
        st.setString(2, topic_id);
        st.executeUpdate();
        st.close();
    }

    public void updatePostViewInfo(Connection forumCon, String topic_id) throws SQLException {
        PreparedStatement selSt = this.createStatement(forumCon, "select post_id from t_post where topic_id=?");
        PreparedStatement delSt = this.createStatement(forumCon, "delete from t_post_viewinfo where post_id=? and user_id=?");
        PreparedStatement inSt = this.createStatement(forumCon, "insert into t_post_viewinfo(post_id, user_id) values(?, ?)");
        selSt.setString(1, topic_id);
        ResultSet selRs = selSt.executeQuery();
        delSt.setString(2, this.getRemoteUser());
        inSt.setString(2, this.getRemoteUser());
        while (selRs.next()) {
            int post_id = selRs.getInt(1);
            delSt.setInt(1, post_id);
            inSt.setInt(1, post_id);
            delSt.executeUpdate();
            inSt.executeUpdate();
        }
        selSt.close();
        delSt.close();
        inSt.close();
    }

    public boolean isStike(String status) throws SQLException {
        boolean ret = false;
        ret = "hidden".equals(status) ? true : ret;
        ret = "viewonly".equals(status) ? true : ret;
        return ret;
    }
}

