/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Object rootHandler;
    private boolean lazyInitHandlers = false;
    private final Map handlerMap = new LinkedHashMap();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setRootHandler(Object rootHandler) {
        this.rootHandler = rootHandler;
    }

    public Object getRootHandler() {
        return this.rootHandler;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Object handler;
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up handler for [" + lookupPath + "]"));
        }
        if ((handler = this.lookupHandler(lookupPath, request)) == null) {
            Object rawHandler = null;
            if ("/".equals(lookupPath)) {
                rawHandler = this.getRootHandler();
            }
            if (rawHandler == null) {
                rawHandler = this.getDefaultHandler();
            }
            if (rawHandler != null) {
                handler = this.buildPathExposingHandler(rawHandler, lookupPath);
            }
        }
        return handler;
    }

    protected Object lookupHandler(String urlPath, HttpServletRequest request) {
        Object handler = this.handlerMap.get(urlPath);
        if (handler != null) {
            return this.buildPathExposingHandler(handler, urlPath);
        }
        String bestPathMatch = null;
        Iterator it = this.handlerMap.keySet().iterator();
        while (it.hasNext()) {
            String registeredPath = (String)it.next();
            if (!this.getPathMatcher().match(registeredPath, urlPath) || bestPathMatch != null && bestPathMatch.length() >= registeredPath.length()) continue;
            bestPathMatch = registeredPath;
        }
        if (bestPathMatch != null) {
            handler = this.handlerMap.get(bestPathMatch);
            String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(bestPathMatch, urlPath);
            return this.buildPathExposingHandler(handler, pathWithinMapping);
        }
        return null;
    }

    protected Object buildPathExposingHandler(Object rawHandler, String pathWithinMapping) {
        if (rawHandler instanceof String) {
            String handlerName = (String)rawHandler;
            rawHandler = this.getApplicationContext().getBean(handlerName);
        }
        HandlerExecutionChain chain = new HandlerExecutionChain(rawHandler);
        chain.addInterceptor(new PathExposingHandlerInterceptor(pathWithinMapping));
        return chain;
    }

    protected void exposePathWithinMapping(String pathWithinMapping, HttpServletRequest request) {
        request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)pathWithinMapping);
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (int j = 0; j < urlPaths.length; ++j) {
            this.registerHandler(urlPaths[j], (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(urlPath)) != null) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map handler [" + handler + "] to URL path [" + urlPath + "]: There is already handler [" + resolvedHandler + "] mapped.");
            }
        } else if (urlPath.equals("/")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Root mapping to handler [" + resolvedHandler + "]"));
            }
            this.setRootHandler(resolvedHandler);
        } else if (urlPath.equals("/*")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Default mapping to handler [" + resolvedHandler + "]"));
            }
            this.setDefaultHandler(resolvedHandler);
        } else {
            this.handlerMap.put(urlPath, resolvedHandler);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped URL path [" + urlPath + "] onto handler [" + resolvedHandler + "]"));
            }
        }
    }

    public final Map getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    private class PathExposingHandlerInterceptor
    extends HandlerInterceptorAdapter {
        private final String pathWithinMapping;

        public PathExposingHandlerInterceptor(String pathWithinMapping) {
            this.pathWithinMapping = pathWithinMapping;
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            AbstractUrlHandlerMapping.this.exposePathWithinMapping(this.pathWithinMapping, request);
            return true;
        }
    }
}

