/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.io.ByteToCharUTF7;
import com.sk_jp.mail.CorrectedContentTypeDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

class CorrectedContentTypeDataSourceUTF7Support
extends CorrectedContentTypeDataSource {
    private boolean utf7 = false;

    public CorrectedContentTypeDataSourceUTF7Support() {
    }

    public CorrectedContentTypeDataSourceUTF7Support(DataSource dataSource, String string) {
        super(dataSource, string);
    }

    public CorrectedContentTypeDataSourceUTF7Support(Part part, String string) throws MessagingException {
        super(part, string);
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.utf7 = false;
    }

    public void setDefaultCharset(String string) {
        super.setDefaultCharset(string);
        this.utf7 = false;
    }

    public String getContentType() {
        try {
            ContentType contentType = new ContentType(super.getContentType());
            String string = contentType.getParameter("charset");
            if ("UTF-7".equalsIgnoreCase(string)) {
                contentType.setParameter("charset", "UTF-16");
                this.utf7 = true;
            }
            return contentType.toString();
        }
        catch (ParseException parseException) {
            throw new InternalError();
        }
    }

    public InputStream getInputStream() throws IOException {
        int n;
        InputStream inputStream;
        block6: {
            inputStream = null;
            if (this.isInvalidEncodingAsMultipart()) {
                inputStream = this.getRawInputStream();
            }
            if (inputStream == null) {
                try {
                    inputStream = super.getInputStream();
                }
                catch (IOException iOException) {
                    inputStream = this.getRawInputStream();
                    if (inputStream != null) break block6;
                    throw iOException;
                }
            }
        }
        if (!this.utf7) {
            return inputStream;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        ByteToCharUTF7 byteToCharUTF7 = new ByteToCharUTF7();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        char[] cArray = new char[byArray.length];
        int n2 = byteToCharUTF7.convert(byArray, 0, byArray.length, cArray, 0, cArray.length);
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        String string = new String(cArray2);
        return new ByteArrayInputStream(string.getBytes("UTF-16"));
    }

    private InputStream getRawInputStream() throws IOException {
        if (!(this.source instanceof MessageAware)) {
            return null;
        }
        Part part = ((MessageAware)this.source).getMessageContext().getPart();
        try {
            if (part instanceof MimeMessage) {
                return ((MimeMessage)part).getRawInputStream();
            }
            if (part instanceof MimeBodyPart) {
                return ((MimeBodyPart)part).getRawInputStream();
            }
            return null;
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.toString());
        }
    }

    private boolean isInvalidEncodingAsMultipart() {
        try {
            if (!new ContentType(this.getContentType()).match("multipart/*")) {
                return false;
            }
            if (!(this.source instanceof MessageAware)) {
                return false;
            }
            Part part = ((MessageAware)this.source).getMessageContext().getPart();
            String string = ((MimePart)part).getEncoding();
            if ("7bit".equalsIgnoreCase(string) || "8bit".equalsIgnoreCase(string) || "binary".equalsIgnoreCase(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

