/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MailSession;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.SKMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Sender {
    private MailSession mailSession;
    private Session session;
    private Transport transport;

    Sender(MailSession mailSession, Session session, Transport transport) {
        this.mailSession = mailSession;
        this.session = session;
        this.transport = transport;
    }

    public String getHost() {
        return this.mailSession.getTransportHost();
    }

    public String getUser() {
        return this.mailSession.getTransportUser();
    }

    public synchronized void connect() throws MessagingException {
        this.transport.connect(null, -1, null, this.mailSession.getTransportPassword());
    }

    public synchronized boolean isConnected() {
        return this.transport.isConnected();
    }

    public synchronized void disconnect() {
        try {
            this.transport.close();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public MimeMessage createMessage() {
        return new SKMessage(this.session);
    }

    public static void setHeaders(MimeMessage mimeMessage, String string, String string2) throws MessagingException, AddressException {
        if (string2 == null) {
            mimeMessage.setFrom();
        } else {
            mimeMessage.setFrom(null);
            mimeMessage.addFrom((Address[])InternetAddress.parse((String)string2, (boolean)true));
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string, (boolean)true));
        mimeMessage.setHeader("X-Mailer", "JavaMail Sender $Revision: 1.6 $");
    }

    public void send(MimeMessage mimeMessage) throws MessagingException {
        this.send(mimeMessage, mimeMessage.getAllRecipients());
    }

    public synchronized void send(MimeMessage mimeMessage, Address[] addressArray) throws MessagingException {
        mimeMessage.setSentDate(new Date());
        this.transport.sendMessage((Message)mimeMessage, addressArray);
    }

    public synchronized void send(MimeMessage mimeMessage, String string, String string2) throws MessagingException, AddressException {
        this.session.getProperties().put("mail.smtp.from", string2);
        this.send(mimeMessage, (Address[])InternetAddress.parse((String)string, (boolean)true));
        this.session.getProperties().remove("mail.smtp.from");
    }

    public void send(String string, String string2, String string3, String string4) throws MessagingException, AddressException {
        MimeMessage mimeMessage = this.createMessage();
        Sender.setHeaders(mimeMessage, string, string2);
        try {
            mimeMessage.setSubject(MailUtility.encodeText(string3, "ISO-2022-JP", "B"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        mimeMessage.setText(string4, "ISO-2022-JP");
        this.send(mimeMessage);
    }

    public synchronized void sendMessage(MimeMessage mimeMessage) throws MessagingException, AddressException {
        this.connect();
        this.send(mimeMessage);
        this.disconnect();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    public static void main(String[] stringArray) throws Exception {
        MailSession mailSession = new MailSession(stringArray[0]);
        if (stringArray.length > 2) {
            mailSession.setTransportAccount(null, null, -1, null, stringArray[2]);
            mailSession.useSMTPAuth(true);
        } else {
            mailSession.setTransportAccount(null, null);
        }
        Sender sender = mailSession.getSender();
        MimeMessage mimeMessage = sender.createMessage();
        Sender.setHeaders(mimeMessage, stringArray[1], null);
        try {
            mimeMessage.setSubject(MailUtility.encodeText("\u3066\u3059\u3068", "ISO-2022-JP", "B"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        mimeMessage.setText("\u65e5\u672c\u8a9e\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u3066\u3059\u3068\u3067\u3059\u3002", "ISO-2022-JP");
        sender.connect();
        sender.send(mimeMessage);
        sender.disconnect();
    }
}

