/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.encoders.Hex;

public class ByteArrayHandler {
    public static byte[] decrypt(byte[] byArray, char[] cArray) throws IOException, PGPException, NoSuchProviderException {
        int n;
        InputStream inputStream = new ByteArrayInputStream(byArray);
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPEncryptedDataList pGPEncryptedDataList = null;
        Object object = pGPObjectFactory.nextObject();
        pGPEncryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)pGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream2 = pGPPBEEncryptedData.getDataStream(cArray, "BC");
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream2);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory2.nextObject();
        pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        InputStream inputStream3 = pGPLiteralData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream3.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static byte[] encrypt(byte[] byArray, char[] cArray, String string, int n, boolean bl) throws IOException, PGPException, NoSuchProviderException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (string == null) {
            string = "_CONSOLE";
        }
        OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        OutputStream outputStream2 = pGPCompressedDataGenerator.open(byteArrayOutputStream2);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream3 = pGPLiteralDataGenerator.open(outputStream2, 'b', string, byArray.length, new Date());
        outputStream3.write(byArray);
        pGPLiteralDataGenerator.close();
        pGPCompressedDataGenerator.close();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(n, new SecureRandom(), "BC");
        pGPEncryptedDataGenerator.addMethod(cArray);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        OutputStream outputStream4 = pGPEncryptedDataGenerator.open(outputStream, byArray2.length);
        outputStream4.write(byArray2);
        outputStream4.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String string = "Dick Beck";
        char[] cArray = string.toCharArray();
        byte[] byArray = "Hello world".getBytes();
        System.out.println("Starting PGP test");
        byte[] byArray2 = ByteArrayHandler.encrypt(byArray, cArray, "iway", 3, true);
        System.out.println("\nencrypted data = '" + new String(byArray2) + "'");
        byte[] byArray3 = ByteArrayHandler.decrypt(byArray2, cArray);
        System.out.println("\ndecrypted data = '" + new String(byArray3) + "'");
        byArray2 = ByteArrayHandler.encrypt(byArray, cArray, "iway", 9, false);
        System.out.println("\nencrypted data = '" + new String(Hex.encode((byte[])byArray2)) + "'");
        byArray3 = ByteArrayHandler.decrypt(byArray2, cArray);
        System.out.println("\ndecrypted data = '" + new String(byArray3) + "'");
    }
}

