/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.util.UrlUtils;

public class FilterInvocation {
    private FilterChain chain;
    private ServletRequest request;
    private ServletResponse response;

    public FilterInvocation(ServletRequest request, ServletResponse response, FilterChain chain) {
        if (request == null || response == null || chain == null) {
            throw new IllegalArgumentException("Cannot pass null values to constructor");
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Can only process HttpServletResponse");
        }
        this.request = request;
        this.response = response;
        this.chain = chain;
    }

    public FilterChain getChain() {
        return this.chain;
    }

    public String getFullRequestUrl() {
        return UrlUtils.getFullRequestUrl(this);
    }

    public HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)this.request;
    }

    public HttpServletResponse getHttpResponse() {
        return (HttpServletResponse)this.response;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public String getRequestUrl() {
        return UrlUtils.getRequestUrl(this);
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return "FilterInvocation: URL: " + this.getRequestUrl();
    }
}

