/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web;

import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.web.AbstractNyxController;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import org.springframework.web.servlet.ModelAndView;

public class DefaultController
extends AbstractNyxController {
    public static final String PARAM_KEY_OUTSCRIPT = "outscript";

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map nyx = (Map)request.getAttribute("nyxSetting");
        TreeMap<String, Object> bean = new TreeMap<String, Object>();
        bean.put("nyx", nyx);
        bean.put("admin", this.isAdminUser(request));
        bean.put("padmin", this.isPersonalAdminUser(request));
        bean.put("status", new TreeMap());
        TreeMap<String, Boolean> res = new TreeMap<String, Boolean>();
        res.put(PARAM_KEY_OUTSCRIPT, true);
        bean.put("res", res);
        ModelAndView mv = new ModelAndView(this.getJspPath(), bean);
        this.webUtil.setAuthRealm(((Setting)nyx.get("kernel_auth_realm")).getValue());
        return mv;
    }

    protected boolean isAdminUser(HttpServletRequest request) {
        Boolean ret = (Boolean)request.getAttribute("nyxAdmin");
        return ret == null ? false : ret;
    }

    protected boolean isPersonalAdminUser(HttpServletRequest request) {
        Boolean ret = (Boolean)request.getAttribute("nyxPersonalAdmin");
        return ret == null ? false : ret;
    }

    protected AccessValidaterUtility.AuthValue getAuthValue(HttpServletRequest request) {
        AccessValidaterUtility.AuthValue ret = (AccessValidaterUtility.AuthValue)request.getAttribute("authValue");
        return ret;
    }

    protected Map<String, String> getStatus(ModelAndView mv) {
        return (Map)mv.getModel().get("status");
    }

    protected Map<String, Setting> getNyx(ModelAndView mv) {
        return (Map)mv.getModel().get("nyx");
    }

    protected Map<String, Object> getRes(ModelAndView mv) {
        return (Map)mv.getModel().get("res");
    }

    protected NyxManager getNyxManager(HttpServletRequest request) {
        return (NyxManager)request.getAttribute("nyxManager");
    }

    protected void setOutScript(ModelAndView mv, boolean outScript) {
        Map<String, Object> res = this.getRes(mv);
        res.put(PARAM_KEY_OUTSCRIPT, outScript);
    }
}

