/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import java.sql.SQLException;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.User;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.common.web.xml.NyxXmlRpcHandlerMapping;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcGetUserHandler
implements NxyXmlRpcHandler {
    private NyxManager nyxManager;
    private SsoManager ssoManager = null;

    public SsoXmlRpcGetUserHandler(SsoManager ssoManager) {
        this.ssoManager = ssoManager;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        if (req.getParameterCount() < 2) {
            throw new XmlRpcException("The RPC is IllegalArgument. Param count is not 2.");
        }
        String selfId = (String)req.getParameter(0);
        String loadId = (String)req.getParameter(1);
        if (NyxXmlRpcHandlerMapping.textUtil.isEmpty(selfId)) {
            throw new XmlRpcException("The RPC is IllegalArgument. Self UserID is empty.");
        }
        if (NyxXmlRpcHandlerMapping.textUtil.isEmpty(loadId)) {
            throw new XmlRpcException("The RPC is IllegalArgument. Load UserID is empty.");
        }
        Access access = AccessFactory.createAccess(PersonalAccess.class);
        try {
            access.setAdmin(this.nyxManager.isAdmin(selfId));
            access.setPersonalAdmin(this.nyxManager.isPersonalAdmin(selfId));
            User self = this.ssoManager.loadUser(selfId);
            access.setSelf(self);
            User user = this.ssoManager.loadUser(loadId, access);
            return user;
        }
        catch (SQLException e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
        catch (NyxException e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    @Override
    public String getMethodName() {
        return "Sso.getUser";
    }
}

