/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.cli;

import java.util.HashSet;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import jp.nyx.pkg.cli.AbstractRpcCommand;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public class RpcCommandManager {
    private ResourceBundle commandProp = PropertyResourceBundle.getBundle("jp.nyx.pkg.cli.commands");
    private Options baseOptions = new Options();
    private Set<AbstractRpcCommand> commandSet = new HashSet<AbstractRpcCommand>();

    public void init(String[] args) throws Exception {
        System.out.println("============================================================");
        System.out.println("[ Nyx-RPC Client version 0.5.9.e ]");
        System.out.println("  Powered by Nyx Kernel ver 0.5.9.e");
        System.out.println("  Copyright (C) 2005-2008 Nyx Project. All right reserved.");
        System.out.println("============================================================");
        this.baseOptions = new Options();
        OptionGroup baseOptionGroup = new OptionGroup();
        for (String cls : this.commandProp.getString("commands").split(",")) {
            Class<?> cmdCls = Class.forName(cls.trim());
            AbstractRpcCommand command = (AbstractRpcCommand)cmdCls.newInstance();
            Options options = command.createDefaultOptions(baseOptionGroup);
            command.initArgs(args, options);
            this.commandSet.add(command);
        }
        this.baseOptions.addOptionGroup(baseOptionGroup);
    }

    public boolean execute(String[] args) throws Exception {
        BasicParser parser = new BasicParser();
        for (AbstractRpcCommand command : this.commandSet) {
            CommandLine cl;
            try {
                cl = parser.parse(command.getOptions(), args);
            }
            catch (UnrecognizedOptionException e) {
                continue;
            }
            if (!cl.hasOption(command.getName())) continue;
            String nyxHeader = cl.getOptionValue("nyxheader", "xmlrpc=http://localhost:8080/portal/xmlrpc");
            try {
                boolean ret = command.execute(cl, nyxHeader);
                if (ret) {
                    System.out.println("Command successed.");
                    return true;
                }
            }
            catch (Exception e) {
                this.showHelp(command.getOptions());
                e.printStackTrace();
            }
            System.out.println("Command failed.");
            return false;
        }
        this.showHelp(this.baseOptions);
        return false;
    }

    protected void showHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("SecureSwitch cli", options, true);
    }

    public static void main(String[] args) {
        RpcCommandManager manager = new RpcCommandManager();
        try {
            manager.init(args);
            manager.execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            manager.showHelp(manager.baseOptions);
        }
    }
}

