/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.portal.spec;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.db.model.PortalNotice;
import org.springframework.web.servlet.ModelAndView;

public class NoticeUtility {
    private WebUtility webUtil = new WebUtility();
    private SsoManager ssoManager;
    private Map<String, Setting> nyx;

    public PortalNotice sendNotice(ModelAndView mv, Map<String, String> status, String from_user_id, String display_start, String display_end, String url, String title, String message, String[] contextCodes, String[] userIds, boolean sendmail) {
        try {
            int i;
            PortalNotice notice = new PortalNotice();
            notice.setFromUserId(from_user_id);
            Calendar now = this.webUtil.calUtil.getCalendar();
            this.webUtil.calUtil.chopDay(now);
            Calendar start = this.webUtil.calUtil.parseCalendar(display_start, "yyyy/MM/dd", null);
            notice.setDisplayStart(start);
            Calendar end = this.webUtil.calUtil.parseCalendar(display_end, "yyyy/MM/dd", null);
            notice.setDisplayEnd(end);
            notice.setNoticeDate(now);
            notice.setUrl(url);
            notice.setTitle(title);
            notice.setMessage(message);
            if (start != null && start.before(now)) {
                status.put("status", "Failed");
                status.put("message", "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002<br/>\u958b\u59cb\u65e5\u304c\u73fe\u5728\u65e5\u3088\u308a\u524d\u3067\u3059\u3002");
                return null;
            }
            if (end != null && end.before(now)) {
                status.put("status", "Failed");
                status.put("message", "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002<br/>\u7d42\u4e86\u65e5\u304c\u73fe\u5728\u65e5\u3088\u308a\u524d\u3067\u3059\u3002");
                return null;
            }
            if (start != null && end != null && end.before(start)) {
                status.put("status", "Failed");
                status.put("message", "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002<br/>\u7d42\u4e86\u65e5\u304c\u958b\u59cb\u65e5\u3088\u308a\u524d\u3067\u3059\u3002");
                return null;
            }
            if (this.webUtil.textUtil.isEmpty(notice.getTitle())) {
                status.put("status", "Failed");
                status.put("message", "\u30bf\u30a4\u30c8\u30eb\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return null;
            }
            if (this.webUtil.textUtil.isEmpty(notice.getMessage())) {
                status.put("status", "Failed");
                status.put("message", "\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return null;
            }
            User self = this.ssoManager.loadUser(from_user_id);
            Access access = AccessFactory.createAccess(PersonalAccess.class);
            access.setPersonalAdmin(true);
            access.setSelf(self);
            HashSet<User> bccSet = new HashSet<User>();
            for (i = 0; contextCodes != null && i < contextCodes.length; ++i) {
                if (this.webUtil.textUtil.isEmpty(contextCodes[i])) continue;
                Context context = this.ssoManager.loadContext((long)this.webUtil.numUtil.parseInt(contextCodes[i]), access, true);
                bccSet.addAll(context.getUser());
            }
            for (i = 0; userIds != null && i < userIds.length; ++i) {
                if (this.webUtil.textUtil.isEmpty(userIds[i])) continue;
                User user = this.ssoManager.loadUser(userIds[i], access);
                bccSet.add(user);
            }
            if (sendmail) {
                String fromName = from_user_id;
                String fromEmail = null;
                try {
                    fromName = self.getUserName();
                    Ext ex = (Ext)self.getExt().get("email");
                    if (ex == null || this.webUtil.textUtil.isEmpty(ex.getFieldValue())) {
                        status.put("status", "Failed.");
                        status.put("message", fromName + "\u3055\u3093\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u901a\u77e5\u767b\u9332\u3068\u30e1\u30fc\u30eb\u9001\u4fe1\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                        return null;
                    }
                    fromEmail = ex.getFieldValue();
                }
                catch (Exception e) {
                    status.put("status", "Failed.");
                    status.put("message", "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f<br>" + e.getMessage());
                    return null;
                }
                StringBuilder mailbody = new StringBuilder();
                mailbody.append(fromName);
                mailbody.append(" \u3055\u3093\u3088\u308a\u901a\u77e5\u304c\u3042\u308a\u307e\u3059\u3002\n");
                mailbody.append("===============================================================\n");
                mailbody.append(title);
                mailbody.append("\n");
                if (!this.webUtil.textUtil.isEmpty(url)) {
                    mailbody.append("[ ");
                    mailbody.append(url);
                    mailbody.append(" ]\n");
                }
                mailbody.append("---------------------------------------------------------------\n");
                mailbody.append(message);
                mailbody.append("\n");
                mailbody.append("===============================================================\n");
                mailbody.append(this.nyx.get("base_app_title").getValue());
                ArrayList<String> bcc = new ArrayList<String>();
                StringBuilder warm = new StringBuilder();
                if (bccSet.size() <= 0) {
                    status.put("status", "Failed");
                    status.put("message", "\u5b9b\u5148\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return null;
                }
                for (User user : bccSet) {
                    Ext ext = (Ext)user.getExt().get("email");
                    if (ext == null || this.webUtil.textUtil.isEmpty(ext.getFieldValue())) {
                        warm.append(user.getUserName());
                        warm.append("(");
                        warm.append(user.getUserId());
                        warm.append(")<br>");
                        continue;
                    }
                    bcc.add(ext.getFieldValue());
                }
                if (warm.length() > 0) {
                    status.put("status", "Warning.");
                    status.put("message", "\u4ee5\u4e0b\u306e\u65b9\u306f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30e1\u30fc\u30eb\u901a\u77e5\u304c\u884c\u308f\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002<br>(\u901a\u77e5\u767b\u9332\u306f\u884c\u308f\u308c\u3066\u3044\u307e\u3059)<br>" + warm.toString());
                }
                this.webUtil.sendmail(this.nyx.get("base_app_smtp_host").getValue(), this.nyx.get("base_app_smtp_port").getValue(), fromEmail, new String[0], new String[0], bcc.toArray(new String[0]), title, new HashMap(), mailbody.toString());
            }
            if (bccSet.size() <= 0) {
                status.put("status", "Failed");
                status.put("message", "\u5b9b\u5148\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return null;
            }
            for (User user : bccSet) {
                notice.setUserId(user.getUserId());
                this.ssoManager.savePortalNotice(notice, true);
            }
            status.put("status", "Successed");
            status.put("message", "\u901a\u77e5\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            return notice;
        }
        catch (Exception e) {
            status.put("status", "Failed");
            status.put("message", "\u901a\u77e5\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>" + e.getMessage());
            NyxException.logger.error((Object)"\u901a\u77e5\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            return null;
        }
    }

    public void setNyx(Map<String, Setting> nyx) {
        this.nyx = nyx;
    }

    public void setSsoManager(SsoManager ssoManager) {
        this.ssoManager = ssoManager;
    }
}

