/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.pkg.sso.db.SsoContextDao;
import jp.nyx.pkg.sso.db.SsoSiteDao;
import jp.nyx.pkg.sso.db.SsoUserDao;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoAuthDao
extends BaseDao {
    private SsoUserDao ssoUserDao;
    private SsoContextDao ssoContextDao;
    private SsoSiteDao ssoSiteDao;
    private ParameterizedRowMapper<Auth> authMapper;
    private NyxManager nyxManager;
    private Map<Long, Auth> cashe = new HashMap<Long, Auth>();

    protected SsoAuthDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate, SsoUserDao ssoUserDao, SsoContextDao ssoContextDao, SsoSiteDao ssoSiteDao) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.ssoUserDao = ssoUserDao;
        this.ssoContextDao = ssoContextDao;
        this.ssoSiteDao = ssoSiteDao;
        this.authMapper = new DefaultParameterizedRowMapper<Auth>(){

            public Auth mapRow(ResultSet rs, int rowNum) throws SQLException {
                Auth ret = new Auth();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setAuthId(rs.getLong("auth_id"));
                ret.setAuthName(rs.getString("auth_name"));
                ret.setTriggerSiteIdInt((long)rs.getInt("trigger_site_id"));
                ret.setAuthType(rs.getString("auth_type"));
                ret.setAuthUse(rs.getString("auth_use"));
                ret.setTieupCode(rs.getLong("tieup_code"));
                ret.setValidSiteIdInt((long)rs.getInt("valid_site_id"));
                ret.setFailerSiteIdInt((long)rs.getInt("failer_site_id"));
                ret.setValidTicket("t".equals(rs.getString("valid_ticket")));
                SsoAuthDao.this.cashe.put(ret.getAuthId(), ret);
                return ret;
            }
        };
    }

    public Auth loadAuth(long authId, Access access) throws SQLException {
        if (this.cashe.containsKey(authId)) {
            return this.cashe.get(authId);
        }
        List ext = this.simpleTemplate.query("select * from m_auth_ext where auth_id=?", this.extMapper, new Object[]{authId});
        Auth ret = (Auth)this.simpleTemplate.queryForObject("select * from m_auth where auth_id=?", this.authMapper, new Object[]{authId});
        Map map = ret.getExt();
        for (Ext ex : ext) {
            map.put(ex.getFieldName(), ex);
        }
        List userIds = this.loadString("user_id", "m_auth_user", "auth_id", authId);
        Set user = ret.getUser();
        for (String i : userIds) {
            user.add(this.ssoUserDao.loadUser(i));
        }
        List contextCodes = this.loadLong("context_code", "m_auth_context", "auth_id", authId);
        Set context = ret.getContext();
        for (Long i : contextCodes) {
            context.add(this.ssoContextDao.loadContext(i, access));
        }
        List appIds = this.loadLong("app_site_id", "m_auth_app", "auth_id", authId);
        Set appSite = ret.getAppSiteId();
        for (Long i : appIds) {
            appSite.add(this.ssoSiteDao.loadSite(i));
        }
        List informIds = this.loadLong("inform_site_id", "m_auth_inform", "auth_id", authId);
        Set informSite = ret.getInformSiteId();
        for (Long i : informIds) {
            informSite.add(this.ssoSiteDao.loadSite(i));
        }
        return ret;
    }

    public List<Auth> loadAuth(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadLong("auth_id", "m_auth", conditions, offset, limit, "auth_name");
        if (ids.size() <= 0) {
            return new ArrayList<Auth>();
        }
        ArrayList<Auth> ret = new ArrayList<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, conditions.getAccess()));
        }
        return ret;
    }

    public Set<Auth> loadAuthUser(String userId, int offset, int limit, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "v_auth_user_verify", "user_id", userId, offset, limit);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public Set<Auth> loadAuthContext(long contextCode, int offset, int limit, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "v_auth_context_verify", "context_code", contextCode, offset, limit);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public Set<Auth> loadAuthAppSite(long siteId, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "m_auth_app", "app_site_id", siteId);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public Set<Auth> loadAuthInformSite(long siteId, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "m_auth_inform", "inform_site_id", siteId);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public Set<Auth> loadAuthValidSite(long siteId, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "m_auth", "valid_site_id", siteId);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public Set<Auth> loadAuthFailSite(long siteId, Access access) throws SQLException {
        List ids = this.loadLong("auth_id", "m_auth", "failer_site_id", siteId);
        if (ids.size() <= 0) {
            return new TreeSet<Auth>();
        }
        TreeSet<Auth> ret = new TreeSet<Auth>();
        for (Long i : ids) {
            ret.add(this.loadAuth(i, access));
        }
        return ret;
    }

    public void saveAuth(Auth auth) throws SQLException {
        int r = this.namedTemplate.update("update m_auth set auth_name=:authName, valid_ticket=:validTicketString " + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ",trigger_site_id=:triggerSiteIdInt ") + ",auth_type=:authType ,auth_use=:authUse ,tieup_code=:tieupCode " + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ",valid_site_id=:validSiteIdInt ") + txtUtil.getEmpty((Object)auth.getFailerSiteIdLong(), ",failer_site_id=:failerSiteIdInt ") + "where auth_id=:authId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)auth));
        if (r > 0) {
            this.saveExt("m_auth_ext", "auth_id", auth.getAuthId(), auth.getExt(), (DefaultModel)auth);
            this.saveRef("m_auth_app", "app_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getAppSiteId(), (DefaultModel)auth);
            this.saveRef("m_auth_inform", "inform_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getInformSiteId(), (DefaultModel)auth);
            this.saveRef("m_auth_user", "user_id", "userId", "auth_id", auth.getAuthId(), auth.getUser(), (DefaultModel)auth);
            this.saveRef("m_auth_context", "context_code", "contextCode", "auth_id", auth.getAuthId(), auth.getContext(), (DefaultModel)auth);
            this.saveSsoDefault("m_auth", "auth_id", auth.getAuthId(), (DefaultModel)auth);
            return;
        }
        long seq = this.nextSequence("m_auth_auth_id_seq");
        auth.setAuthId(seq);
        this.namedTemplate.update("insert into m_auth(auth_id, auth_name, valid_ticket" + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ", trigger_site_id") + ", auth_type, auth_use, tieup_code" + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ", valid_site_id") + txtUtil.getEmpty((Object)auth.getFailerSiteIdLong(), ", failer_site_id") + ") values(:authId, :authName, :validTicketString" + txtUtil.getEmpty((Object)auth.getTriggerSiteIdInt(), ", :triggerSiteIdInt") + ", :authType, :authUse, :tieupCode" + txtUtil.getEmpty((Object)auth.getValidSiteIdInt(), ", :validSiteIdInt") + txtUtil.getEmpty((Object)auth.getFailerSiteIdLong(), ", :failerSiteIdInt") + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)auth));
        this.saveExt("m_auth_ext", "auth_id", auth.getAuthId(), auth.getExt(), (DefaultModel)auth);
        this.saveRef("m_auth_app", "app_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getAppSiteId(), (DefaultModel)auth);
        this.saveRef("m_auth_inform", "inform_site_id", "siteId", "auth_id", auth.getAuthId(), auth.getInformSiteId(), (DefaultModel)auth);
        this.saveRef("m_auth_user", "user_id", "userId", "auth_id", auth.getAuthId(), auth.getUser(), (DefaultModel)auth);
        this.saveRef("m_auth_context", "context_code", "contextCode", "auth_id", auth.getAuthId(), auth.getContext(), (DefaultModel)auth);
        this.saveSsoDefault("m_auth", "auth_id", auth.getAuthId(), (DefaultModel)auth);
    }

    public void deleteAuth(long auth_id) {
        this.simpleTemplate.update("delete from m_auth_ext where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_inform where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_app where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_context where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth_user where auth_id=?", new Object[]{auth_id});
        this.simpleTemplate.update("delete from m_auth where auth_id=?", new Object[]{auth_id});
    }

    public void clearCashe() {
        this.cashe.clear();
    }

    public boolean isDerby() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return !"postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }

    public boolean isPostgreSQL() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return "postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }
}

