/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.spec;

import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.util.NumberUtility;
import jp.nyx.pkg.ca.db.CaManager;
import jp.nyx.pkg.sso.spec.ClientSocketParam;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;
import org.springframework.context.ApplicationContext;

public class ClientSocketPool
extends StackKeyedObjectPool {
    public ClientSocketPool(int max, int init, ApplicationContext context, Map<String, Setting> nyx) throws NyxException {
        this._factory = new ClientSocketFactory(context, nyx);
        this._maxSleeping = max;
        this._initSleepingCapacity = init;
    }

    public synchronized Object borrowObject(Object param) throws Exception {
        Socket socket = (Socket)this._factory.makeObject(param);
        return socket;
    }

    private class ClientSocketFactory
    extends BaseKeyedPoolableObjectFactory {
        private static final String ATTR_CADATASOURCE = "caDataSource";
        private CaManager caManager;
        private Access access;
        private boolean initCaManager = false;
        private Map<String, Setting> nyx;
        private NumberUtility numUtil = new NumberUtility();

        private ClientSocketFactory(ApplicationContext context, Map<String, Setting> nyx) throws NyxException {
            if (!this.initCaManager) {
                DataSource caDs = (DataSource)context.getBean(ATTR_CADATASOURCE);
                try {
                    Method m = caDs.getClass().getMethod("setDriverClassName", String.class);
                    m.invoke((Object)caDs, nyx.get("ca_jdbc_driver").getValue());
                    m = caDs.getClass().getMethod("setUrl", String.class);
                    m.invoke((Object)caDs, nyx.get("ca_jdbc_url").getValue());
                    m = caDs.getClass().getMethod("setUsername", String.class);
                    m.invoke((Object)caDs, nyx.get("ca_jdbc_user").getValue());
                    m = caDs.getClass().getMethod("setPassword", String.class);
                    m.invoke((Object)caDs, nyx.get("ca_jdbc_pass").getValue());
                }
                catch (Exception e) {
                    throw new NyxException((Throwable)e);
                }
            }
            this.nyx = nyx;
            this.caManager = (CaManager)context.getBean("caManager");
            this.caManager.init(context);
            this.access = AccessFactory.createAccess(PersonalAccess.class);
            ConditionList conditions = new ConditionList(this.access);
            SSLSocketFactory factory = this.caManager.generateSSLSocketFactory(conditions);
            HostnameVerifier verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
        }

        public Object makeObject(Object param) throws Exception {
            ClientSocketParam p = (ClientSocketParam)param;
            if (!p.isSsl()) {
                Socket socket = new Socket(p.getHost(), p.getPort());
                socket.setSoTimeout(this.numUtil.parseInt(this.nyx.get("kernel_proxysocket_timeout").getValue(), 45000));
                return socket;
            }
            ConditionList conditions = new ConditionList(this.access);
            SSLSocketFactory factory = this.caManager.generateSSLSocketFactory(conditions);
            SSLSocket socket = (SSLSocket)factory.createSocket(p.getHost(), p.getPort());
            socket.setSoTimeout(this.numUtil.parseInt(this.nyx.get("kernel_proxysocket_timeout").getValue(), 45000));
            socket.startHandshake();
            return socket;
        }
    }
}

