/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.Tieup;
import jp.nyx.common.db.model.User;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class AuthController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String auth_type_search;
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        String mode = request.getParameter("mode");
        mv.getModel().put("authTypes", Auth.AuthType.values());
        mv.getModel().put("authTypeMap", Auth.AuthType.getMap());
        mv.getModel().put("authUses", Auth.AuthUse.values());
        mv.getModel().put("authExtNames", Auth.AuthExtNames.values());
        if ("user_search".equals(mode)) {
            ConditionList uc = new ConditionList(access);
            uc.add((Object)new Condition("user_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            List<User> users = ssoManager.loadUser(0, 100, uc);
            mv.getModel().put("users", users);
            return mv;
        }
        if ("context_search".equals(mode)) {
            ConditionList cc = new ConditionList(access);
            cc.add((Object)new Condition("context_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            List<Context> contexts = ssoManager.loadContext(0, 100, cc);
            mv.getModel().put("contexts", contexts);
            return mv;
        }
        if ("app_search".equals(mode)) {
            ConditionList scapp = new ConditionList(access);
            scapp.add((Object)new Condition("site_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            scapp.add((Object)new Condition("site_type", (Object)Site.SiteType.APP.getValue()));
            List<Site> apps = ssoManager.loadSite(0, 100, scapp);
            ConditionList scope = new ConditionList(access);
            scope.add((Object)new Condition("site_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            scope.add((Object)new Condition("site_type", (Object)Site.SiteType.OPERATION.getValue()));
            apps.addAll(ssoManager.loadSite(0, 100, scope));
            mv.getModel().put("apps", apps);
            return mv;
        }
        ConditionList cond = new ConditionList(access);
        String auth_name_search = request.getParameter("auth_name_search");
        if (!this.webUtil.textUtil.isEmpty(auth_name_search)) {
            cond.add((Object)new Condition("auth_name", (Object)("%" + auth_name_search + "%"), "like"));
        }
        String string = auth_type_search = this.webUtil.textUtil.isEmpty(auth_type_search = request.getParameter("auth_type_search")) ? "BASIC_AUTH" : auth_type_search;
        if (!"all".equals(auth_type_search)) {
            cond.add((Object)new Condition("auth_type", (Object)auth_type_search));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_auth", cond));
        List<Auth> auths = ssoManager.loadAuth(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("auths", auths);
        if ("add".equals(mode)) {
            Auth auth = new Auth();
            mv.getModel().put("auth", auth);
            ConditionList c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.TRIGGER.getValue()));
            List<Site> triggers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("triggers", triggers);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.VALID.getValue()));
            List<Site> valids = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("valids", valids);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.FAILER.getValue()));
            List<Site> failers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("failers", failers);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.INFORM.getValue()));
            List<Site> informs = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("informs", informs);
            boolean f = false;
            Iterator i$ = auth.getInformSiteId().iterator();
            if (i$.hasNext()) {
                Site inf = (Site)i$.next();
                mv.getModel().put("informSiteId", inf.getSiteId());
                f = true;
            }
            if (!f) {
                mv.getModel().put("informSiteId", null);
            }
            c = new ConditionList(access);
            c.add((Object)new Condition("tieup_type", (Object)Tieup.TiupType.QUERY.getValue()));
            mv.getModel().put("tieups", this.getNyxManager(request).loadTieup(0, 1000, c));
        } else if ("adddo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Auth auth = new Auth();
                auth.setRegistUid(this.getRemoteUser(mv));
                auth.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(auth, request, status, ssoManager, access)) {
                    return mv;
                }
                ssoManager.saveAuth(auth);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(mode)) {
            Auth auth = ssoManager.loadAuth((long)this.webUtil.numUtil.parseInt(request.getParameter("auth_id")), access);
            auth.setVerifyEnddate(this.webUtil.calUtil.addDay(auth.getVerifyEnddate(), -1));
            mv.getModel().put("auth", auth);
            mv.getModel().put("extKeies", auth.getExt().keySet());
            ConditionList c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.TRIGGER.getValue()));
            List<Site> triggers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("triggers", triggers);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.VALID.getValue()));
            List<Site> valids = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("valids", valids);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.FAILER.getValue()));
            List<Site> failers = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("failers", failers);
            c = new ConditionList(access);
            c.add((Object)new Condition("site_type", (Object)Site.SiteType.INFORM.getValue()));
            List<Site> informs = ssoManager.loadSite(0, 1000, c);
            mv.getModel().put("informs", informs);
            boolean f = false;
            Iterator i$ = auth.getInformSiteId().iterator();
            if (i$.hasNext()) {
                Site inf = (Site)i$.next();
                mv.getModel().put("informSiteId", inf.getSiteId());
                f = true;
            }
            if (!f) {
                mv.getModel().put("informSiteId", null);
            }
            c = new ConditionList(access);
            c.add((Object)new Condition("tieup_type", (Object)Tieup.TiupType.QUERY.getValue()));
            mv.getModel().put("tieups", this.getNyxManager(request).loadTieup(0, 1000, c));
        } else if ("editdo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Auth auth = ssoManager.loadAuth((long)this.webUtil.numUtil.parseInt(request.getParameter("auth_id")), access);
                if (!this.save(auth, request, status, ssoManager, access)) {
                    return mv;
                }
                auth.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveAuth(auth);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deleteAuth(this.webUtil.numUtil.parseInt(request.getParameter("auth_id")));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(Auth auth, HttpServletRequest request, Map<String, String> status, SsoManager ssoManager, Access access) throws NoSuchAlgorithmException, MessagingException, IOException, NyxException {
        int i;
        String auth_name = request.getParameter("auth_name");
        if (this.webUtil.textUtil.isEmpty(auth_name)) {
            status.put("status", "Failed");
            status.put("message", "\u6a29\u9650\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        auth.setAuthName(auth_name);
        auth.setAuthType(request.getParameter("auth_type"));
        auth.setAuthUse(request.getParameter("auth_use"));
        auth.setTieupCode(this.webUtil.numUtil.parseLong((Object)request.getParameter("tieup_code")));
        auth.setTriggerSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("trigger_site_id")));
        auth.setValidSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("valid_site_id")));
        auth.setFailerSiteIdInt((long)this.webUtil.numUtil.parseInt(request.getParameter("failer_site_id")));
        String inform_site_id = request.getParameter("inform_site_id");
        Set ref = auth.getInformSiteId();
        ref.clear();
        if (!this.webUtil.textUtil.isEmpty(inform_site_id)) {
            ref.add(ssoManager.loadSite(this.webUtil.numUtil.parseInt(inform_site_id)));
        }
        String[] users = request.getParameterValues("user");
        Set ref2 = auth.getUser();
        ref2.clear();
        for (i = 0; users != null && i < users.length; ++i) {
            ref2.add(ssoManager.loadUser(users[i]));
        }
        String[] contexts = request.getParameterValues("context");
        ref2 = auth.getContext();
        ref2.clear();
        for (i = 0; contexts != null && i < contexts.length; ++i) {
            ref2.add(ssoManager.loadContext((long)this.webUtil.numUtil.parseInt(contexts[i]), access));
        }
        String[] apps = request.getParameterValues("app");
        ref2 = auth.getAppSiteId();
        ref2.clear();
        for (i = 0; apps != null && i < apps.length; ++i) {
            ref2.add(ssoManager.loadSite(this.webUtil.numUtil.parseInt(apps[i])));
        }
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                Calendar cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                auth.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            auth.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                Calendar cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                cal.add(6, 1);
                auth.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            auth.setVerifyEnddate(null);
        }
        auth.setValidTicket("true".equals(request.getParameter("valid_ticket")));
        auth.setEnable("true".equals(request.getParameter("enable")));
        String[] field_name = request.getParameterValues("field_name[]");
        Map ext = auth.getExt();
        ext.clear();
        for (int i2 = 0; field_name != null && i2 < field_name.length; ++i2) {
            if (this.webUtil.textUtil.isEmpty(field_name[i2])) continue;
            String field_del = request.getParameter("field_del[" + field_name[i2] + "]");
            String field_value = request.getParameter("field_value[" + field_name[i2] + "]");
            String field_type = request.getParameter("field_type[" + field_name[i2] + "]");
            String field_display = request.getParameter("field_display[" + field_name[i2] + "]");
            Ext p = new Ext();
            if ("true".equals(field_del)) {
                p.setSessionDisable(true);
            }
            this.save(auth, ext, p, field_name[i2], field_value, field_type, field_display);
        }
        String field_name_new = request.getParameter("field_name_new");
        if (!this.webUtil.textUtil.isEmpty(field_name_new)) {
            String field_value_new = request.getParameter("field_value_new");
            String field_type_new = request.getParameter("field_type_new");
            String field_display_new = request.getParameter("field_display_new");
            Ext p = new Ext();
            this.save(auth, ext, p, field_name_new, field_value_new, field_type_new, field_display_new);
        }
        return true;
    }

    private void save(Auth auth, Map<String, Ext> param, Ext p, String field_name, String field_value, String field_type, String field_display) {
        p.setFieldName(field_name);
        p.setFieldType(this.webUtil.textUtil.nvl(field_type));
        p.setFieldValue(this.webUtil.textUtil.nvl(field_value));
        p.setFieldDisplay(this.webUtil.textUtil.nvl(field_display));
        p.setRegistUid(auth.getUpdateUid());
        p.setUpdateUid(auth.getUpdateUid());
        p.setVerifyStartdate(auth.getVerifyStartdate());
        p.setVerifyEnddate(auth.getVerifyEnddate());
        p.setEnable(true);
        param.put(p.getFieldName(), p);
    }
}

